#if !defined(_STATUSWINDOW_H)
#define _STATUSWINDOW_H

#include <Window.h>
#include <Button.h>
#include <StopWatch.h>
#include <Dragger.h>
#include <MessageRunner.h>

#define private public			// XXX HUGE hack...
#include <StatusBar.h>
#undef private

#include <vector>

#define USE_ELAPSED_TIME 1	// if defined the status window popoup delay will depend on the time actually
							// spend with the operation not the absolute time since it bigan (when there's
							// a dialog window this timer is paused)
namespace BPrivate {

static const bigtime_t	kPopUpDelay						= 800000;	// operations that does not take at least kPopUpDelay long will not open the status window

class StatusWindow : public BWindow {
friend StatusWindow &gStatusWindow();
	class ContextView;
	typedef BWindow						inherited;

	class ContainerView : public BView {
		typedef BView inherited;
		friend class StatusWindow;
		
		static const char * const kClassName = "StatusWindow::ContainerView";
		
		void initialize();
	public:
		ContainerView();
		~ContainerView();
		ContainerView(BMessage *);
		
		static BArchivable *Instantiate(BMessage *);
				status_t	Archive(BMessage *, bool) const;
				
				void		Add(TFSContext &);
				void		Remove(const TFSContext &);
				bool		ShouldPause(const TFSContext &);
				void		Draw(BRect);
				void		AllAttached();
				void		MessageReceived(BMessage *);
				void		ModifiersChanged();
				void		Pack();				// render things again
				bool		AttemptToQuit();	// cancel pending operations

				void		CustomPulse();
				void		SetPulseRate(bigtime_t rate);
				void		RedrawDragger(int32 offset = 0);
								
		static	bool		HasReplicantInstance()	{ return sReplicantInstance != 0; }
		static ContainerView &ReplicantInstance()	{ return *sReplicantInstance; }

	private:
		static ContainerView *sReplicantInstance;

		#if USE_ELAPSED_TIME
		bigtime_t			mInitTime;				// the system_time() when the last status view was added
		#endif
		BMessageRunner *	mPulseMessageRunner;	// this is required because it's not wise to depend on DesktopWindow::PulseRate
		bool				mPackNeeded;
		bool				mReplicant;
	};
	

	class StatusView : public BView {
		typedef BView		inherited;
		friend class ContainerView;
		
		class CustomButton : public BButton {
			typedef BButton inherited;

		public:
			enum button_type {
				kStop = 1,
				kPause,
				kPlay,
				kSkipRight
			};

			CustomButton(button_type in_type, uint32 in_what) : inherited(BRect(), "", "", new BMessage(in_what),
											B_FOLLOW_LEFT + B_FOLLOW_TOP, B_WILL_DRAW | B_NAVIGABLE), mType(in_type) {}
			void	Draw(BRect);
			void	SetSign(button_type in_type)	{ mType = in_type; Invalidate(Bounds()); }
		button_type	Sign() const					{ return mType; }

		private:
			button_type		mType;
		};

		class ProgressView : public BView {	// the view with the progress bars
			friend class StatusView;
		public:
			ProgressView(TFSContext &);
			~ProgressView();
		
					void		AllAttached();
					void		GetPreferredSize(float *, float *);
					void		Draw(BRect);
					void		DrawCurrentEntry();
					void		FrameResized(float, float);
					void		CustomPulse();
					void		SetMode();
					const char *FilterOperationForDisplay(TFSContext::operation op);

					void		SetOperationString();
					int32		GetSizeString(char *in_ptr, float in_size1, float in_size2);
					
					void		SetVerbose(bool in_state)	{ mVerbose = in_state; }
					bool		IsVerbose() const			{ return mVerbose; }
		
		private:
			static bool							sDefaultVerboseState;

			TFSContext &						mContext;
			TFSContext::operation				mMode;
			BStatusBar							mStatusBar;
//			float								mCountStringPosition,
//												mTotalSizeStringPosition,
//												mSizeStringPosition;
			bool								mVerbose;
			bool								mSyncLossDetected;
		};

	public:
		StatusView(TFSContext &);
		~StatusView();
		
				void		AllAttached();
				void		GetPreferredSize(float *, float *);
				void		Draw(BRect);
				void		MouseDown(BPoint point)		{ assert_cast<CustomDragger *>(Parent() -> Parent()) -> MouseDown(point); }
				void		FrameResized(float, float);
				void		MessageReceived(BMessage *);

				void		ModifiersChanged();
				void		DrawEstimatedTimeString();
				bigtime_t	EstimatedTimeLeft()							{ return mContext.EstimatedTimeLeft(); }
				void		CustomPulse();
				void		Pack();
				TFSContext &FSContext()									{ return mContext; }
				bool		ShouldShow() const							{ return (mContext.RealElapsedTime()  >  (kPopUpDelay * 1.2)); }
				
				void		Cancel()									{ mContext.Cancel(); }
				
				bool		operator==(const TFSContext &in_context)	{ return &mContext == &in_context; }
		
	private:
		static float			sFontHeight;
		static font_height		sFontHeightStruct;
		
		bigtime_t				mLastTimeUpdated;
		TFSContext &			mContext;
		ProgressView			mProgressView;
		CustomButton			mStopButton,
								mPauseButton,
								mSkipButton;
		BRect					mLeftVisibleRect,
								mRightVisibleRect,
								mTimeRect;
		BBitmap *				mBitmap;
	};

	class CustomDragger : public BDragger {
		typedef BDragger inherited;
		static const char * const kClassName = "StatusWindow::CustomDragger";
	public:
			CustomDragger(BView &view) : inherited(BRect(), &view, B_FOLLOW_ALL,
											B_WILL_DRAW + B_DRAW_ON_CHILDREN) {}
			void		Draw(BRect)						{ if (IsVisibilityChanging()) assert_cast<ContainerView *>(Target()) -> RedrawDragger(); }
			void		DrawAfterChildren(BRect rect)	{ inherited::Draw(rect); }
			status_t	Archive(BMessage *msg, bool deep);
	};

public:
	StatusWindow();
	~StatusWindow();

			void		Add(TFSContext &);
			void		Remove(const TFSContext &);
			bool		ShouldPause(const TFSContext &);
			void		DispatchMessage(BMessage *, BHandler *);
			void		Pack();
		ContainerView &	Container()					{ ASSERT(IsLocked()); return mContainer; }
				

			DEBUG_ONLY(
				void		Show();
			)
			bool		QuitRequested();

			bool		AttemptToQuit()				{ return mContainer.AttemptToQuit(); }

private:
	static StatusWindow *	sSelf;
	static int32			sInitialized;

	ContainerView 			mContainer;
	CustomDragger			mDragger;
};


inline StatusWindow &
gStatusWindow() {
	if (atomic_or(&StatusWindow :: sInitialized, 1) == 0) {
		StatusWindow :: sSelf = new StatusWindow();
	}
	return *StatusWindow :: sSelf;
}

}	// namespace BPrivate

#endif // _STATUSWINDOW_H

