
#ifndef __WIZARDPAD_DEVICE_H
#define __WIZARDPAD_DEVICE_H

#include <InterfaceDefs.h>
#include <SerialPort.h>
#include <add-ons/input_server/InputServerDevice.h>
#include <List.h>
#include <OS.h>
#include <SupportDefs.h>

extern "C" _EXPORT BInputServerDevice* instantiate_input_device();

class WizardPadDevice : public BInputServerDevice {
public:
							WizardPadDevice();
	virtual					~WizardPadDevice();

	virtual status_t		InitCheck();

	virtual status_t		Start(const char *device, void *cookie);
	virtual	status_t		Stop(const char *device, void *cookie);
	virtual status_t		Control(const char	*device,
									void		*cookie,
									uint32		code, 
									BMessage	*message);

	int32 thread();
private:
	int32 get_byte();
	void adjust_speed() {
		int32 speed;
		get_mouse_speed( &speed );
		speed_multiplier = (float)speed / (float)(1 << 16);
	}

	// Thread management
	bool quit;
	thread_id threadid;

	// Serial port
	BSerialPort serial;

	// Configuration
	float speed_multiplier;
	bigtime_t dbl_clk_speed;
	bool absolute_coord;
	int32 btn_tip, btn_barrel, btn_ext1, btn_ext2, btn_eraser;
};

#endif // __WIZARDPAD_DEVICE_H
