// Z-Viewer, written by Zenja Solaja, December 2000
// Z-Viewer is a zoomable image viewer.

#include <AppKit.h>
#include <InterfaceKit.h>

#include "main.h"
#include "ZScrollView.h"
#include "linked_list.h"

ZListWindow	*zv_listwindow;
BScrollView *fscrollview;
		
//=============================
ZListWindow::ZListWindow(BRect frame)
	: BWindow(frame, "Image List", B_DOCUMENT_WINDOW, /*B_NOT_RESIZABLE |*/ B_NOT_ZOOMABLE | B_NOT_CLOSABLE | B_WILL_ACCEPT_FIRST_CLICK)
{
	//BRect aRect(0,0,145-B_V_SCROLL_BAR_WIDTH,300);
	BRect aRect(0, 0, frame.Width()-B_V_SCROLL_BAR_WIDTH, frame.Height());
	flistview = new BListView(aRect, "ZVListView", B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL_SIDES, B_WILL_DRAW|B_NAVIGABLE|B_FRAME_EVENTS);
	
	flistview->SetInvocationMessage(new BMessage(ITEM_SELECTED_MSG));
	fscrollview = new BScrollView("ZVImageList", flistview, B_FOLLOW_ALL_SIDES, 0, false, true, B_FANCY_BORDER);
	AddChild(fscrollview);
}

/* When updating scroll view, its necessary to lock the window - otherwise, say 'Hello' to Mr.bdb */

//============================
void ZListWindow::AddItem(BStringItem *item)
{
	flistview->LockLooper(); 
	flistview->AddItem(item);
	flistview->UnlockLooper(); 
}

//============================
void ZListWindow::EmptyList()
{
	flistview->LockLooper(); 
	flistview->MakeEmpty();
	flistview->UnlockLooper(); 
}

//============================
void ZListWindow::MessageReceived(BMessage *message)
{
	switch(message->what){
		case ITEM_SELECTED_MSG:
		{
			int32 selected = flistview->CurrentSelection(0);
			list_navigation->position = list_navigation->head;
			while (selected--) { 
				list_navigation->position = list_navigation->position->next;
			}
			zv_window->PrepareBitmap(list_navigation->position->contents); 
			break;
		}
		default:
			BWindow::MessageReceived(message);
	}
}

//============================
void ZListWindow::UpdateSelection()
{
	int32 count = 0;
	
	if (list_navigation->head == list_navigation->tail) // check if only 1 element in list
	{
		if (!zv_listwindow->IsHidden())
			zv_listwindow->Hide();
		return;
	}

	if (zv_listwindow->IsHidden())
		zv_listwindow->Show();
				
	LINKED_LIST *where = list_navigation->head;	
	while (where != list_navigation->position && where != list_navigation->tail)
	{
		count++;
		where = where->next;
	}	
	
	//Highlight new selection
	flistview->LockLooper(); 
	flistview->Select(count, false);
	flistview->ScrollToSelection(); 
	flistview->UnlockLooper();
}


		