#! gmake

## AbiSource Program Utilities, libwv wrapper
## Copyright (C) 1998 AbiSource, Inc.
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License
## as published by the Free Software Foundation; either version 2
## of the License, or (at your option) any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
## 02111-1307, USA.

ABI_ROOT:=$(shell pwd)/../abi
ABI_PEER:=/wv

# awkward work-around to avoid system-installed libole2 headers
INCLUDES= -I.

include $(ABI_ROOT)/src/config/abi_defs.mk

CSRCS= \
	winmmap.c \
	twips.c \
	escher.c \
	symbol.c \
	mtextra.c \
	support.c \
	list.c \
	stylesheet.c \
	sprm.c \
	blip.c \
	utf.c \
	field.c \
	decompresswmf.c \
	dop.c \
	roman.c \
	fib.c \
	fdoa.c \
	fopt.c \
	frd.c \
	atrd.c \
	sed.c \
	font.c \
	ffn.c \
	fld.c \
	bkf.c \
	dttm.c \
	generic.c \
	error.c \
	unicode.c \
	sttbf.c \
	xst.c \
	fspa.c \
	fbse.c \
	lst.c \
	lvl.c \
	lfo.c \
	filetime.c \
	chp.c \
	brc.c \
	anld.c \
	shd.c \
	dcs.c \
	numrm.c \
	asumyi.c \
	version.c \
	lspd.c \
	phe.c \
	tlp.c \
	tc.c \
	tap.c \
	pap.c \
	bintree.c \
	decode_simple.c \
	pcd.c \
	prm.c \
	clx.c \
	bte.c \
	bx.c \
	fkp.c \
	text.c \
	decode_complex.c \
	wvTextEngine.c \
	wvHtmlEngine.c \
	wvparse.c \
	reasons.c \
	sep.c \
	anlv.c \
	olst.c \
	asumy.c \
	bkd.c \
	bkl.c \
	dogrid.c \
	doptypography.c \
	pgd.c \
	rs.c \
	rr.c \
	tbd.c \
	ftxbxs.c \
	wkb.c \
	picf.c \
	crc32.c \
	md5.c \
	rc4.c \
	decrypt97.c \
	decrypt95.c \
	table.c \
	isbidi.c \
	plcf.c \

EXPORTERSOURCES = \
	exporter/anld.c \
	exporter/anlv.c \
	exporter/asumy.c \
	exporter/asumyi.c \
	exporter/atrd.c \
	exporter/bkd.c \
	exporter/bkf.c \
	exporter/bkl.c \
	exporter/brc.c \
	exporter/bte.c \
	exporter/bx.c \
	exporter/chp.c \
	exporter/dcs.c \
	exporter/dogrid.c \
	exporter/dop.c \
	exporter/doptypography.c \
	exporter/dttm.c \
	exporter/fdoa.c \
	exporter/ffn.c \
	exporter/fib.c \
	exporter/filetime.c \
	exporter/fld.c \
	exporter/font.c \
	exporter/frd.c \
	exporter/fspa.c \
	exporter/ftxbxs.c \
	exporter/generic.c \
	exporter/lfo.c \
	exporter/lspd.c \
	exporter/lst.c \
	exporter/lvl.c \
	exporter/numrm.c \
	exporter/olst.c \
	exporter/pcd.c \
	exporter/pgd.c \
	exporter/phe.c \
	exporter/prm.c \
	exporter/rr.c \
	exporter/rs.c \
	exporter/sed.c \
	exporter/sep.c \
	exporter/shd.c \
	exporter/stylesheet.c \
	exporter/summary.c \
	exporter/support.c \
	exporter/tbd.c \
	exporter/tc.c \
	exporter/tlp.c \
	exporter/wkb.c \
	exporter/wvexporter.c

CSRCS+= $(EXPORTERSOURCES)

#CFLAGS+=		-I. -I./exporter/ -I./iconv -DCONFIGFILE=\".mswordview\" -DTTFDIR=\"\" -DSYMBOLFONTDIR=\"\" -DPATTERNDIR=\"\" -DWINGDINGFONTDIR=\"\"


#if Abi ever supports WMF files embedded inside of Word Docs, append
#-DSYSTEM_ZLIB=1 to the CFLAGS
CFLAGS+= -DHAVE_CONFIG_H -I. -I./exporter/ -I../libiconv/include -I./expat/xmlparse -Ioledecod -DHAVE_ZLIB -DCONFIGFILE=\".mswordview\" -DTTFDIR=\"\" -DSYMBOLFONTDIR=\"\" -DPATTERNDIR=\"\" -DWINGDINGFONTDIR=\"\" 
 
CSRCS+= \
	laolareplace.c \
	libole2/ms-ole.c \
	libole2/ms-ole-summary.c

CFLAGS+= \
	-I./libole2
	
	
ifdef GLIB_CONFIG

else

CSRCS+= \
	glib-wv/garray.c \
	glib-wv/glist.c \
	glib-wv/gmem.c \
	glib-wv/gmessages.c \
	glib-wv/gslist.c \
	glib-wv/gstrfuncs.c \
	glib-wv/gtree.c

CFLAGS+= \
	-I./glib-wv

endif
 



LIBRARY_NAME=		wv
LIBRARY_VERSION=	$(ABI_VERSION)
#TARGETS=		$(SHARED_LIBRARY)
TARGETS=		$(LIBRARY) 
LEX=			flex

include $(ABI_ROOT)/src/config/abi_rules.mk

build:: $(TARGETS)

#leave this line here

