/*
Original authors:
   Sed Barbouky
   Christian Klein
*/
#include <fcntl.h>
#include <unistd.h>
#include <SupportDefs.h>
#include "dump_wav.h"

static bool inited=false;
static int32 dumpfd,
             size;

// return 0 if error, 1 if not
int init_dump_wav(const char *fname)
{
  int16 dum16;
  uint32 dum32;

  if ((dumpfd=open(fname, O_WRONLY|O_CREAT|O_TRUNC, 0644))==-1) return 0;
  if (
     write(dumpfd, "RIFF", 4)!=4 ||
     (dum32=36, write(dumpfd, &dum32, 4)!=4) ||       // header size
     write(dumpfd, "WAVEfmt ", 8)!=8 ||
     (dum32=16, write(dumpfd, &dum32, 4)!=4) ||       // chunk size  
     (dum16=1, write(dumpfd, &dum16, 2)!=2) ||        // format tag (1 = uncompressed PCM)
     (dum16=1, write(dumpfd, &dum16, 2)!=2) ||        // no of channels
     (dum32=44100, write(dumpfd, &dum32, 4)!=4) ||    // rate
     (dum32=44100*2, write(dumpfd, &dum32, 4)!=4) ||  // average bytes/sec
     (dum16=(16+7)/8, write(dumpfd, &dum16, 2)!=2) || // block align
     (dum16=16, write(dumpfd, &dum16, 2)!=2) ||       // bits per sample
     write(dumpfd, "data", 4)!=4 ||
     (dum32=0, write(dumpfd, &dum32, 4)!=4)           // sample length (0 for now)
  ) goto error;

  if (close(dumpfd)==-1) return 0;
  if ((dumpfd=open(fname, O_WRONLY, 0644))==-1) return 0;
  if (lseek(dumpfd, 0, SEEK_END)==-1) goto error;
  inited=true;
  size=36;
  return 1;

  error:
  close(dumpfd);
  return 0;
}

int close_dump_wav(void) {
  if (!inited) return 0;
  inited=false;

  // update the wav header
  lseek(dumpfd, 4, SEEK_SET);  // first place to update
  if (write(dumpfd, &size, 4)!=4) goto error;
  size-=36;
  lseek(dumpfd, 40, SEEK_SET); // second place
  if (write(dumpfd, &size, 4)!=4) goto error;

  if (close(dumpfd)==-1) return 0;
  return 1;

  error:
  close(dumpfd);
  return 0;
}

int dump_wav(char *buf, int s) {
  if (!inited) return 0;
  if (write(dumpfd, buf, s)!=s) {
    close_dump_wav();
    return 0;
  }
  size+=s;
  return 1;
}
/*
#include <printf.h>
#include <math.h>
#define NB_SAMPLE 2048
int main() {
  int n,m,res;
  int16 buf[NB_SAMPLE],
        val;
  res=init_dump_wav("out.wav");
  printf("init:%d\n",res);
  for (n=0,val=0;n<30;++n) {
    for (m=0;m<NB_SAMPLE;++m) {
      val+=5; val=val%628;
      buf[m]=(int16)(10000. * sin(val/100.));
    }
    res=dump_wav((char*)buf,NB_SAMPLE*2);
    if (!res) break;
  }
  printf("dump:%d\n",res);
  res=close_dump_wav();
  printf("close:%d\n",res);
}
*/
