#include <Bitmap.h>
#include "bitmaps.h"

Bitmaps::Bitmaps() {
  const uint8 _ = B_TRANSPARENT_MAGIC_CMAP8,
              b = 0,  // black
              r = 0x2a, // red
              u = 0x20;  // blue
  static uint8
    sharp[] = {
      _,_,_,_,_,_,_,_,
      _,_,_,b,_,b,_,_,
      _,b,b,b,b,b,_,_,
      _,_,b,_,b,_,_,_,
      _,_,b,_,b,_,_,_,
      _,b,b,b,b,b,_,_,
      _,b,_,b,_,_,_,_,
      _,_,_,_,_,_,_,_
    },
    flat[] = {
      _,_,_,_,_,_,_,_,
      _,_,b,_,_,_,_,_,
      _,_,b,_,_,_,_,_,
      _,_,b,b,b,_,_,_,
      _,_,b,_,_,b,_,_,
      _,_,b,_,b,_,_,_,
      _,_,b,b,_,_,_,_,
      _,_,_,_,_,_,_,_
    },
    dum[] = {
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b,
      b,b,b,b,b,b,b,b
    };

  (dum_bm = new BBitmap(BRect(0,0,7,7),B_CMAP8))->SetBits(dum,64,0,B_CMAP8);
  (sharp_bm = new BBitmap(BRect(0,0,7,7),B_CMAP8))->SetBits(sharp,64,0,B_CMAP8);
  (flat_bm  = new BBitmap(BRect(0,0,7,7),B_CMAP8))->SetBits(flat,64,0,B_CMAP8);
}

BBitmap *Bitmaps::get(int bm) {
  switch (bm) {
    case eSharp: return sharp_bm;
    case eFlat: return flat_bm;
    default: return dum_bm;
  }
}

/*
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,b,b,b,b,b,b,b,_,_,_,_,_,
    _,_,_,_,b,_,_,_,_,_,b,_,_,_,_,_,
    _,_,_,_,b,_,_,.,_,_,b,_,_,_,_,_,
    _,_,_,_,b,_,.,.,.,_,b,_,_,_,_,_,
    _,_,_,_,b,_,_,.,_,_,b,_,_,_,_,_,
    _,_,_,_,b,_,_,_,_,_,b,_,_,_,_,_,
    _,_,_,_,b,b,b,b,b,b,b,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_
*/

const uint8 
  sq_cursor_data[4+2*32] = {
    16,1,7,7,
    0,0,
    0,0,
    0,0,
    0,0,
    15,224,
    8,32,
    8,32,
    8,32,
    8,32,
    8,32,
    8,32,
    15,224,
    0,0,
    0,0,
    0,0,
    0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  },
  pnt_cursor_data[68] = {
    16,1,7,7,
    0,0,
    0,0,
    0,0,
    0,0,
    0,0,
    0,0,
    1,0,
    3,128,
    1,0,
    0,0,
    0,0,
    0,0,
    0,0,
    0,0,
    0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
