#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <support/SupportDefs.h>

#include "../driver/amdcpu.h"

char str[256];
int err;

void setMTRR(int fd, AMDSignature sig) {
  MTRRInterface mi;

  if (sig.family == 6 || (sig.family == 5 && 
      (sig.model > 8 || (sig.model == 8 && sig.stepping > 7)))) {
  
    printf(" enter mtrr baseaddr size. eg 1 0xfd000000 0x1000000\n");
    printf(" to exit press enter at the prompt\n");
    for(;;) {
      printf("> ");
      gets(str);
      if (strlen(str)==0) break;
      if (sscanf(str,"%d %x %x", &(mi.mtrr), &(mi.address), &(mi.size)) == 3) {
        printf("select a mode\n");
        printf(" 0. off\n 1. uncacheable\n 2. write combining\n");
        if (sig.family == 6) printf(" 3. write through\n 4. write protect\n 5. write back\n");
        printf(" > ");
        gets(str);
        if (strlen(str)==0) break;
        if (sscanf(str,"%d", &mi.mode)!=1) {
          printf("error try entering everything again\n");
          continue;
        }

        printf("attempting to setting MTRR %d with base address 0x%x with size 0x%x\n", mi.mtrr, mi.address, mi.size);

        err = ioctl(fd, AMD_SET_MTRR, &mi, sizeof(mi));
        fprintf(stderr,"Attempting to verify mtrr\n");

        if(ioctl(fd, AMD_GET_MTRR, &mi, sizeof(mi)) < 0) {
          printf(" error\n");
        } else {
          printf(" addr 0x%x, size 0x%x=%d, mode ", mi.address, mi.size, mi.size);
          switch(mi.mode) {
          case MTRR_OFF: printf("off\n"); break;
          case MTRR_NO_CACHE: printf("none caching\n"); break;
          case MTRR_WRITE_COMBINE: printf("write combining\n"); break;
          case MTRR_WRITE_THROUGH: printf("write through\n"); break;
          case MTRR_WRITE_PROTECT: printf("write protect\n"); break;
          case MTRR_WRITE_BACK: printf("write back\n"); break;
          default: printf("unknown\n");
          }
        }
 
        if (err < 0) {
          printf(" error setting mtrr\n");
        } else {
          printf(" mtrr set\n");
        }
        break;
      } else {
        printf("invalid input try again\n");
      }
    }
  }
}

void setWriteAlloc(int fd, AMDSignature sig) {
  int mem;

  if (sig.family == 5) {
  
    printf(" enter memory size eg. > 128\n");
    printf(" to exit press enter at the prompt\n");
    for(;;) {
      printf("> ");
      gets(str);
      if (strlen(str)==0) break;
      if (sscanf(str,"%d", &mem) == 1) {
        err = ioctl(fd, AMD_SET_WRITE_ALLOCATE, &mem, sizeof(mem));
        if (err < 0) {
          printf("  Error setting write alloc\n");
        } else {
          printf("Write Alloc %d MB\n", mem);
        }
      } else {
        printf("invalid input try again\n");
      }
    }
  }
}

void setWriteAllocHole(int fd, AMDSignature sig) {
  int mem;
  
  if (sig.family == 5) {
    printf(" enter 1 to write alloc hole, 0 to turn off write alloc\n");
    printf(" to exit press enter at the prompt\n");
    for(;;) {
      printf("> ");
      gets(str);
      if (strlen(str)==0) break;
      if (sscanf(str,"%d", &mem) == 1) {
        err = ioctl(fd, AMD_SET_WRITE_ALLOC_HOLE, &mem, sizeof(mem));
        if (err < 0) {
          printf("  Error setting write alloc hole\n");
        } else {
          printf("Write Alloc hole set\n");
        }
      } else {
        printf(" Invalid input try again\n");
      }
    }
  }
}

void setMult(int fd, AMDSignature sig) {
  int mult;
  
  if (sig.family == 5) {
    printf(" enter multiplier index 0-7 = 2.0x - 6.0x\n");
    printf(" to exit press enter at the prompt\n");
    for(;;) {
      printf("> ");
      gets(str);
      if (strlen(str)==0) break;
      if (sscanf(str,"%d", &mult) == 1) {
        err = ioctl(fd, AMD_SET_MULTIPLIER, &mult, sizeof(mult));
        if (err < 0) {
          printf("  Error setting write alloc hole\n");
        } else {
          printf("Multiplier set\n");
        }
      } else {
        printf(" Invalid input try again\n");
      }
    }
  }
}


int main() {
	int fd;
	status_t err;
    AMDSignature sig;
    int choice;
    	   
	fd = open("/dev/misc/amd-cpu", O_RDWR);
	if (fd < 0) {
		printf("Error opening device\n");
		return 1;
	}

    err = ioctl(fd, AMD_GET_SIGNATURE, &sig, sizeof(sig));
    if (err < 0) {
      printf("Error: getting processor Signature\n");
      return 1;
    } else {
      if (sig.family == 5) {
        printf("processor: AMD K6");
        if (sig.model < 8 || (sig.model == 8 && sig.stepping < 8)) {
          if (sig.model == 8) printf("-2");
          printf(": 504 MB write alloc\n");
        } else if (sig.model == 8) {
          printf("-2 CX: 4GB write alloc, MTRRs, 3DNow, 100Mhz bus\n");
        } else if (sig.model == 9) {
          printf("-3: 4GB write alloc, MTRRs, 3DNow+, 100Mhz bus, 256K on die L2\n");
        } else if (sig.model == 0xd) {
          if (sig.stepping < 4) {
            printf("-3+");
          } else {
            printf("-2+");
          }
          printf(":4GB write alloc, MTRRs, 3DNow+, PowerNow, 100Mhz bus, on die L2\n");
        } else {
          printf("unknown version\n");
        }
      } else if (sig.family == 6) {
        printf("processor: AMD Athlon 8 variable range MTRRs\n");
      } else {
        printf("unknown AMD processor\n");
      }  
      printf("  family 0x%x, model 0x%x, stepping 0x%x\n", sig.family, sig.model, sig.stepping);
    }
 
    for(;;) {
      printf("\nMenu\n");
      if (sig.family == 6 || (sig.family == 5 && 
         (sig.model > 8 || (sig.model == 8 && sig.stepping > 7)))) {
        printf("1) Set MTRR\n");
      }
      if (sig.family == 5) {
        printf("2) Set Write Allocate\n");
        printf("3) Set Write Allocate Hole\n");
        if (sig.model == 0xd) {
          printf("4) Set Multiplier\n");
        }
      }
      printf("9) Quit\n");
      printf("cmd> ");
      gets(str);
      if (sscanf(str, "%d", &choice)==1) {
        switch(choice) {
        case 1: setMTRR(fd, sig);
                break;
        case 2: setWriteAlloc(fd, sig);
                break;
        case 3: setWriteAllocHole(fd, sig);
                break;
        case 4: setMult(fd, sig);
                break;
        case 9: goto end;
                break;
        }
      }
    }
    
end:        
  	close(fd);
	return 0;
}

