#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <support/SupportDefs.h>

#include "../driver/amdcpu.h"


void printMSRS(MSRs *msrs) {
	printf("EFER: SCE %d, DPE %d, EWBW %d, L2Disabled %d\n", msrs->efer.SCE,
		msrs->efer.DPE, msrs->efer.EWBE, msrs->efer.L2Disabled);
	printf("WHCR: hole? %d, WAELimit 0x%x\n", msrs->whcr.hole, msrs->whcr.WAELIMIT);
	printf("MTRR: UCO %d, WCO %d, Mask0 0x%x, Base0 0x%x\n", msrs->mtrr.UC0, msrs->mtrr.WC0, msrs->mtrr.MASK0, msrs->mtrr.BASE0);
	printf("      UC1 %d, WC1 %d, Mask1 0x%x, Base1 0x%x\n", msrs->mtrr.UC1, msrs->mtrr.WC1, msrs->mtrr.MASK1, msrs->mtrr.BASE1);
	printf("PSOR: EBF %d, STEP %d, NOL2 %d, VID %d, PBF %d\n", msrs->psor.EBF, msrs->psor.STEP, msrs->psor.NOL2, msrs->psor.VID, msrs->psor.PBF);
	printf("EPMR: EN %d, GSBC %d, IOBase 0x%x\n", msrs->epmr.EN, msrs->epmr.GSBC, msrs->epmr.IOBASE);
}

MSRs msrs;
int mult;

int main() {
	int fd;
    char bb[4*8];
    int i;
    MTRRInterface mi;
    AMDSignature sig;
	status_t err;
	   
	fd = open("/dev/misc/amd-cpu", O_RDWR);
	if (fd < 0) {
		printf("Error opening device amd-cpu\n");
		return 1;
	}
 
    err = ioctl(fd, AMD_GET_SIGNATURE, &sig, sizeof(sig));
    if (err < 0) {
      printf("Error: getting processor Signature\n");
      return 1;
    } else {
      if (sig.family == 5) {
        printf("processor: AMD K6");
        if (sig.model < 8 || (sig.model == 8 && sig.stepping < 8)) {
          if (sig.model == 8) printf("-2");
          printf(": 504 MB write alloc\n");
        } else if (sig.model == 8) {
          printf("-2 CX: 4GB write alloc, MTRRs, 3DNow, 100Mhz bus\n");
        } else if (sig.model == 9) {
          printf("-3: 4GB write alloc, MTRRs, 3DNow+, 100Mhz bus, 256K on die L2\n");
        } else if (sig.model == 0xd) {
          if (sig.stepping < 4) {
            printf("-3+");
          } else {
            printf("-2+");
          }
          printf(":4GB write alloc, MTRRs, 3DNow+, PowerNow, 100Mhz bus, on die L2\n");
        } else {
          printf("unknown version\n");
        }
      } else if (sig.family == 6) {
        printf("processor: AMD Athlon 8 variable range MTRRs\n");
      } else {
        printf("unknown AMD processor\n");
      }  
      printf("  family 0x%x, model 0x%x, stepping 0x%x\n", sig.family, sig.model, sig.stepping);
    }
    
    if (sig.family == 5) {
      printf("\nGet K6 MSRS\n");
      err = ioctl(fd, AMD_GET_K6MSRS, &msrs, sizeof(msrs));
      if (err < 0) {
        printf("  Error\n");
      } else {
        printMSRS(&msrs);
      }
      
      printf("\nGet Write Alloc: ");
      err = ioctl(fd, AMD_GET_WRITE_ALLOCATE, &mult, sizeof(mult));
      if (err < 0) {
        printf("  Error\n");
      } else {
        printf("Write Alloc %d MB\n", mult);
      }
      
      printf("\nGet Write Alloc hole: ");
      err = ioctl(fd, AMD_GET_WRITE_ALLOC_HOLE, &mult, sizeof(mult));
      if (err < 0) {
        printf("  Error\n");
      } else {
        printf("Write Alloc 15-16 MB hole? ");
        if (mult) printf("yes\n"); else printf("no\n");
      }
    
      printf("\nGet MTRRS\n");
      for (i=0; i<2; i++) {
        printf("  mtrr %d: ", i);
        mi.mtrr = i;
        err = ioctl(fd, AMD_GET_MTRR, &mi, sizeof(mi));
        if (err < 0) {
          printf(" error\n");
        } else {
          printf(" addr 0x%x, size 0x%x=%d, mode ", mi.address, mi.size, mi.size);
          switch(mi.mode) {
          case MTRR_OFF: printf("off\n"); break;
          case MTRR_NO_CACHE: printf("none caching\n"); break;
          case MTRR_WRITE_COMBINE: printf("write combining\n"); break;
          case MTRR_WRITE_THROUGH: printf("write through\n"); break;
          case MTRR_WRITE_PROTECT: printf("write protect\n"); break;
          case MTRR_WRITE_BACK: printf("write back\n"); break;
          default: printf("unknown\n");
          }
        }
      }

      printf("\nGet Multiplier Strings: ");
      err = ioctl(fd, AMD_GET_MULTIPLIER_STRINGS, bb, sizeof(bb));
      if (err < 0) {
        printf("  Error\n");
      } else {
        for (i=0; i<8; i++) printf("%s,", &(bb[i*4]));
      }

      printf("\nGet Multiplier index: ");
      err = ioctl(fd, AMD_GET_MULTIPLIER, &mult, sizeof(mult));
      if (err < 0) {
        printf("  Error\n");
      } else {
        printf("  %d\n", mult);
      }

      printf("\nGet Max Multiplier index: ");
      err = ioctl(fd, AMD_GET_MAX_MULTIPLIER, &mult, sizeof(mult));
      if (err < 0) {
        printf("  Error\n");
      } else {
        printf("  %d\n", mult);
      }
   
        
     } else if (sig.family == 6) {
      printf("\nGet MTRRS\n");
      for (i=0; i<8; i++) {
        printf("  mtrr %d: ", i);
        mi.mtrr = i;
        err = ioctl(fd, AMD_GET_MTRR, &mi, sizeof(mi));
        if (err < 0) {
          printf(" error\n");
        } else {
          printf(" addr 0x%x, size 0x%x=%d, mode ", mi.address, mi.size, mi.size);
          switch(mi.mode) {
          case MTRR_OFF: printf("off\n"); break;
          case MTRR_NO_CACHE: printf("none caching\n"); break;
          case MTRR_WRITE_COMBINE: printf("write combining\n"); break;
          case MTRR_WRITE_THROUGH: printf("write through\n"); break;
          case MTRR_WRITE_PROTECT: printf("write protect\n"); break;
          case MTRR_WRITE_BACK: printf("write back\n"); break;
          default: printf("unknown\n");
          }
        }
      }
    }
    
	
	close(fd);
	return 0;
}

