#ifndef AMDCPU_H
#define AMDCPU_H

  // IO control function numbers
  enum {AMD_GET_K6MSRS=900,
        AMD_GET_FLAGS,
        AMD_GET_WRITE_ALLOCATE,
        AMD_SET_WRITE_ALLOCATE,
        AMD_GET_WRITE_ALLOC_HOLE,
        AMD_SET_WRITE_ALLOC_HOLE,
        AMD_GET_MTRR,
        AMD_SET_MTRR,
        AMD_GET_WRITE_ORDERING,
        AMD_SET_WRITE_ORDERING,
        AMD_GET_MULTIPLIER,
        AMD_SET_MULTIPLIER,
        AMD_GET_MULTIPLIER_STRINGS,
        AMD_GET_MAX_MULTIPLIER,
        AMD_SET_MAX_MULTIPLIER,
        AMD_SET_TO_MAX_MULTIPLIER,
        AMD_INC_MULTIPLIER,
        AMD_DEC_MULTIPLIER,
        AMD_GET_SIGNATURE};


  // K6-2 MSR numbers
  enum {MSR_EFER=0xC0000080,
        MSR_UWWHCR=0xC0000082,
        MSR_UWCCR=0xC0000085,
        MSR_EPMR=0xC0000086,
        MSR_PSOR=0xC0000087};

  // k6-2 write mtrr modes
  enum {MTRR_NOEFFECT, MTRR_UNCACHEABLE, MTRR_WRITECOMBINE};
  
  // AMD Signature
  typedef struct {
    unsigned stepping:4;
    unsigned model:4;
    unsigned family:4;
    unsigned pad0:20;
  } AMD_SIGNATURE;
  
  // k6 - MSR Register Info - each is 64 bits wide
  typedef struct {
    unsigned SCE:1;
    unsigned DPE:1;
    unsigned EWBE:2;
    unsigned L2Disabled:1;
    unsigned pad0:27;
    unsigned pad1:32;
  } EFER;

  //models 6,7,8[0-7]
  typedef struct {
    unsigned hole:1;		// write allocate the 15-16M range
    unsigned WAELIMIT:7;	// only supports 508 Mbytes
    unsigned WCDE:1;		// always set to 0
    unsigned pad0:23;
    unsigned pad1:32;
  } WHCR_OLD;
  
  //models 8[8-f], 9
  typedef struct {
    unsigned pad0:16;
    unsigned hole:1;		// write allocate the 15-16M range
    unsigned pad1:5;
    unsigned WAELIMIT:10;	// supports 4 Gbytes
    unsigned pad2:32;
  } WHCR;

  typedef struct{
    unsigned UC0:1;
    unsigned WC0:1;
    unsigned MASK0:15;
    unsigned BASE0:15;
    unsigned UC1:1;
    unsigned WC1:1;
    unsigned MASK1:15;
    unsigned BASE1:15;
  } MTRR;

  typedef struct {
    unsigned EBF:3;
    unsigned pad0:1;
    unsigned STEP:4;
    unsigned NOL2:1;
    unsigned pad1:7;
    unsigned VID:5;
    unsigned PBF:3;
    unsigned pad2:8;
    unsigned pad3:32;
  } PSOR;

  typedef struct {
    unsigned EN:1;
    unsigned GSBC:1;
    unsigned pad0:2;
    unsigned IOBASE:12;
    unsigned pad1:16;
    unsigned pad2:32;
  } EPMR;

  typedef struct {
    uint32 a, b;
  } RAW;
	
  typedef struct {
    unsigned VIDO:5;
    unsigned IBF:3;
    unsigned BDC:2;
    unsigned VIDC:1;
    unsigned BVCM:1;
    unsigned SGTC:20;
  } BVC;
			
typedef union {
	EFER efer;
	WHCR whcr;
    WHCR_OLD whcrold;
	MTRR mtrr;
	PSOR psor;
	EPMR epmr;
	RAW  raw;
} AllMSRTypes;

typedef struct {
	EFER efer;
	WHCR whcr;
	MTRR mtrr;
	PSOR psor;
	EPMR epmr;
} MSRs;

typedef enum {MTRR_OFF,      					// 'n' in config file
              MTRR_NO_CACHE,					// 'u'
              MTRR_WRITE_COMBINE,				// 'c'
              MTRR_WRITE_THROUGH,				// 't'
              MTRR_WRITE_PROTECT,				// 'p'
              MTRR_WRITE_BACK} MTRRFlags;		// 'b'
                 
typedef struct {
  int mtrr;		// 0-1 k6, 0-7 Athlon
  unsigned int address;
  unsigned int size;
  MTRRFlags mode;
} MTRRInterface;

// Used with the EFER
enum EFERWriteOrdering {EFER_strict, EFER_speculative=4, EFER_global=8};


// Athlon variable range MTRR
#define PGE_FLAG 7
#define CD_FLAG 30
#define NW_FLAG 29
#define MTRRenable bit 11
#define MTRRdefTypeReg 0x2ff
#define ATHLON_MTRR_BASE 0x200


typedef struct {
  unsigned type:8;
  unsigned pad0:4;
  unsigned baselow:20;		// high 24 bits of a 36 bit address
  unsigned basehigh:4;
  unsigned pad1:28;
} MTRRPhysBase;

typedef struct {
  unsigned pad0:11;
  unsigned v:1;			// valid
  unsigned masklow:20;
  unsigned maskhigh:4;
  unsigned pad1:28;
} MTRRMask;

typedef struct {
  unsigned stepping:4;
  unsigned model:4;
  unsigned family:4;
  unsigned pad:20;
} AMDSignature;

#endif
