/*
	IDE bus manager interface for BeOS R4.5 x86

	cf. Be Newsletter Volume II, Issue 20
	"BE ENGINEERING INSIGHTS: Splitting Device Drivers and Bus Managers"
*/

#ifndef	_IDE_H
#define	_IDE_H

#include	<drivers/bus_manager.h>

/* get_abs_bus_num() return values */

#define	B_IDE_BUS_PRIMARY	0
#define	B_IDE_BUS_SECONDARY	1
#define	B_IDE_BUS_OTHER		(-1)

/* IDE bus information */

typedef uchar ide_task_file;	/* pointing to 7-byte array */
typedef int ide_reg_mask;		/* lower 7 bits valid */

typedef struct {
	bus_manager_info	binfo;

	/* bus management functions */
	uint32		(*get_nth_cookie)	(uint32 bus);
	uint32		(*get_bus_count)	(void);
	int32		(*get_abs_bus_num)	(uint32 cookie);
	status_t	(*acquire_bus)		(uint32 cookie);
	status_t	(*release_bus)		(uint32 cookie);

	/* task file access functions */
	status_t	(*write_command_block_regs)
				(uint32 cookie, ide_task_file *tf, ide_reg_mask mask);
	status_t	(*read_command_block_regs)
				(uint32 cookie, ide_task_file *tf, ide_reg_mask mask);
	uint8		(*get_altstatus)		(uint32 cookie);
	void		(*write_device_control)	(uint32 cookie, uint8 val);

	/* PIO transfer functions */
	void		(*write_pio_16)	(uint32 cookie, uint16 *data, uint16 count);
	void		(*read_pio_16)	(uint32 cookie, uint16 *data, uint16 count);

	/* synchronization functions */
	status_t	(*intwait)	(uint32 cookie, bigtime_t timeout);

	/* DMA functions */
	status_t	(*prepare_dma)
				(uint32 cookie, void *buffer, size_t *size, bool to_device);
	status_t	(*start_dma)				(uint32 cookie);
	status_t	(*finish_dma)				(uint32 cookie);

	/* additional DMA functions */
	int			(*get_bad_alignment_mask)	(uint32 cookie);
	status_t	(*get_dma_mode)				(uint32 cookie, uint8 x, uint32 y);
	status_t	(*set_dma_mode)				(uint32 cookie, ...);
} ide_bus_info;

#endif
