
status_t	enable	(int socket, cookie_t *cookie)
{
	uint8	TupleData [256];
	status_t result;
	uint32	ConfigBase;
	uint16	BasePort1, BasePort2;
	int		NumPorts1, NumPorts2;
	int		ConfigIndex, nth, irq;
	struct ParsedConfigEntryTuple_t	Parsed, DefaultParsed;
	struct range	r1, r2;

	/* check function ID */

#if 0
	if ((result = GetSingleTuple (socket, CISTPL_FUNCID, 1,
		TupleData, sizeof TupleData)) != B_OK)
	{
		dprintf (DRIVER_NAME ": can't get card's function ID "
			"in socket %d\n", socket);
		return B_ERROR;
	}
	if (TupleData [2] != FUNCID_DISK)
	{
		dprintf (DRIVER_NAME ": card in socket %d is "
			"not supported\n", socket);
		return B_ERROR;
	}
#endif

	/* check vendor and product */

	if ((result = GetSingleTuple (socket, CISTPL_VERS_1, 1,
		TupleData, sizeof TupleData)) != B_OK)
	{
		dprintf (DRIVER_NAME ": can't get card's name "
			"in socket %d\n", socket);
		return B_ERROR;
	}
	else
	{
		char	*vendor, *product;

		vendor = &TupleData [4];
		product = strchr (vendor, '\0') + 1;
		dprintf (DRIVER_NAME ": card is \"%s\" \"%s\"\n", vendor, product);
#if 0
		if (strcmp (vendor, "") != 0 ||
		    strcmp (product, "") != 0)
		{
			dprintf (DRIVER_NAME ": card in socket %d is "
				"not supported\n", socket);
			return B_ERROR;
		}
#endif
	}
#if 1
	/* analyze configuration tuple */

	if ((result = GetSingleTuple (socket, CISTPL_CONFIG, 1,
		TupleData, sizeof TupleData)) != B_OK)
	{
		dprintf (DRIVER_NAME ": can't get card's configuration info "
			"in socket %d\n", socket);
		return B_ERROR;
	}
	else
	{
		ConfigBase = 0;
		switch (TupleData [2] & 3)
		{
		case 3:	ConfigBase |= TupleData [7] << 24;
		case 2:	ConfigBase |= TupleData [6] << 16;
		case 1:	ConfigBase |= TupleData [5] <<  8;
		case 0:	ConfigBase |= TupleData [4];
		}
	}
	dprintf (DRIVER_NAME ": ConfigBase=0x%x\n", ConfigBase);

	/* analyze configuration entry tuples */

	memset (&DefaultParsed, 0, sizeof DefaultParsed);
	for (nth = 1; ; nth++)
	{
		if ((result = GetSingleTuple (socket, CISTPL_CFTABLE_ENTRY, nth,
			TupleData, sizeof TupleData)) != B_OK)
			break;

		Parsed = DefaultParsed;
		ParseConfigEntryTuple (&TupleData [2], TupleData [1], &Parsed);
		if (Parsed.Default)
			DefaultParsed = Parsed;
		ConfigIndex = Parsed.ConfigIndex;

		/* skip memory-card-mode configuration */
		if (ConfigIndex == 0)
			continue;

		if (Parsed.IORange && Parsed.IOAddrSize > 0)
			/* overlapping mode entry */
		{
			BasePort1 = Parsed.IOAddrRange [0].Start;
			NumPorts1 = Parsed.IOAddrRange [0].Len;

			if (Parsed.IOAddrRanges < 2)
				BasePort2 = NumPorts2 = 0;
			else
			{
				BasePort2 = Parsed.IOAddrRange [1].Start;
				NumPorts2 = Parsed.IOAddrRange [1].Len;
			}

			dprintf (DRIVER_NAME ": overlapping mode entry: ConfigIndex=0x%x, BasePort1=0x%x, NumPorts1=%d, BasePort2=0x%x, NumPorts2=%d\n", ConfigIndex, BasePort1, NumPorts1, BasePort2, NumPorts2);

			/* avoid primary/secondary IDE channels */

			if (BasePort1 == 0x1f0 && BasePort2 == 0x3f6)
				continue;
			if (BasePort1 == 0x170 && BasePort2 == 0x376)
				continue;

			/* check I/O ranges */

			r1.start = BasePort1;
			r1.end = BasePort1 + NumPorts1 - 1;
			if (check_free_resource (&io_list, &r1) == B_ERROR /*||
				check_free_io (&r1) == B_ERROR*/)
				continue;

			if (NumPorts2 > 0)
			{
				r2.start = BasePort2;
				r2.end = BasePort2 + NumPorts2 - 1;
				if (check_free_resource (&io_list, &r2) == B_ERROR /*||
					check_free_io (&r2) == B_ERROR*/)
					continue;
			}

			/* determine configuration type */

			if (NumPorts1 == 8 && (NumPorts2 == 1 || NumPorts2 == 2))
			{
				cookie->cmd_blk_regs_base = BasePort1;
				cookie->ctrl_blk_regs_base = BasePort2;	/* typically BasePort1 + 0x206 */
				cookie->type = IDE_TYPE_IO_STD;
				dprintf (DRIVER_NAME ": overlapping mode: passed\n");
				break;
			}
			else if (NumPorts1 == 10)
			{
				/* IBM CD-400(S), CD-20X(S) */
				cookie->cmd_blk_regs_base = BasePort1;
				cookie->ctrl_blk_regs_base = BasePort1 + 8;
				cookie->type = IDE_TYPE_IO_STD;
				dprintf (DRIVER_NAME ": overlapping mode: passed\n");
				break;
			}
			else
			{
				dprintf (DRIVER_NAME ": unknown configuration entry in socket %d\n", socket);
			}
		}
		else	/* independent mode entry */
		{
			dprintf (DRIVER_NAME ": independent mode entry: ConfigIndex=0x%x, IOAddrLines=%d\n", ConfigIndex, Parsed.IOAddrLines);
			NumPorts1 = 1 << Parsed.IOAddrLines;
			BasePort2 = NumPorts2 = 0;

			for (BasePort1 = 0x100; BasePort1 < 0x400; BasePort1 += NumPorts1)
			{
				r1.start = BasePort1;
				r1.end = BasePort1 + NumPorts1 - 1;
				if (check_free_resource (&io_list, &r1) == B_OK &&
					check_free_io (&r1) == B_OK)
					break;
			}
			if (BasePort1 < 0x400)
			{
				cookie->cmd_blk_regs_base = BasePort1;
				cookie->ctrl_blk_regs_base = BasePort1 + 14;
				cookie->type = IDE_TYPE_IO_CONT_16;
				break;
			}
		}
	}

	if (result != B_OK)
	{
		dprintf (DRIVER_NAME ": can't get appropriate configuration entry "
			"in socket %d\n", socket);
		return B_ERROR;
	}

	/* choose free IRQ */

	{
		uint32	mask;

		/* XXX: IRQ14/15 should be avoided */

		mask = get_resource_mask (&irq_mask);
		for (irq = 0; irq < 16 && mask > 0; irq++, mask >>= 1)
			if ((mask & 1) == 0)
				break;
		if (irq == 16)
		{
			dprintf (DRIVER_NAME ": no free IRQ\n");
			return B_ERROR;
		}
		cookie->irq = irq;
	}
#else
	ConfigBase = 0x200;
	ConfigIndex = 0x21;
	cookie->cmd_blk_regs_base = BasePort1 = 0x180;
	cookie->ctrl_blk_regs_base = BasePort2 = 0x386;
	NumPorts1 = 8;
	NumPorts2 = 2;
	cookie->type = IDE_TYPE_IO_STD;
	cookie->irq = irq = 11;
#endif

	/* configuration */

	dprintf (DRIVER_NAME ": Configuration: ConfigBase=0x%x, ConfigIndex=0x%x, "
		"BasePort1=0x%x, NumPorts1=%d, BasePort2=0x%x, NumPorts2=%d, "
		"IRQ%d\n",
		ConfigBase, ConfigIndex,
		BasePort1, NumPorts1, BasePort2, NumPorts2,
		irq);

	RequestIO (socket, BasePort1, NumPorts1, BasePort2, NumPorts2);
	RequestIRQ (socket, irq);
	RequestConfiguration (socket, ConfigBase, ConfigIndex | 0x40, 0);
	add_resource_mask (&irq_mask, 1 << irq);
	add_resource_list (&io_list, &r1);
	if (NumPorts2 > 0)
		add_resource_list (&io_list, &r2);
	dprintf (DRIVER_NAME ": card in socket %d is configured\n", socket);
	return B_OK;
}
