#! /bin/sh

# customizable section

WK=/tmp

# IDE/ATAPI PC Card driver
NAME=atacard
DESTDIR=beos/system/add-ons/kernel/busses/ide
SRCDIR=./obj.x86
COPY=1

# aic78xx driver (for Adaptec patch)
#NAME=aic78xx
#DESTDIR=beos/system/add-ons/kernel/busses/scsi
#SRCDIR=/system/add-ons/kernel/busses/scsi
#PATCHSCRIPT=./patchaic.sh

# opening

echo "This script will create a new installation floppy"
echo "including a new or updated device driver."
echo

# check new driver

if [ ! "x$COPY" = x ]
then
	[ -e $SRCDIR/$NAME ] && DRIVER=$SRCDIR/$NAME
	# current directory has precedence
	[ -e $NAME ] && DRIVER=$NAME
	if [ x$DRIVER = x ]
	then
		echo "Device driver \"$NAME\" not found."
		exit 1
	fi
fi

# determine device file for floppy drive

if [ "x$FD" = x ]
then
	OS=`uname -s`
	case $OS in
	BeOS)
		FD=/dev/disk/floppy/raw
		echo "This system is BeOS. Uses $FD."
		;;
	Linux)
		FD=/dev/fd0
		echo "This system is Linux. Uses $FD."
		;;
	*BSD)
		FD=/dev/rfd0
		echo "This system is BSD. Uses $FD."
		;;
	*)
		echo "Unknown system. Set FD=/dev/device-file-for-floppy-drive"
		exit 1
		;;
	esac
fi
if [ ! -w $FD ]
then
	echo "$FD is not writable."
	exit 1
fi

rm -rf $WK/boot.img $WK/boot.tgz $WK/newboot.img $WK/newboot.tgz $WK/beos

# find floppy image or read original floppy

if [ -e zbeos ]
then
	ln -s $PWD/zbeos $WK/boot.img
else
	echo "Insert the original R4.5(.x) installation floppy (write-protected) "
	echo "and press Enter."
	read foo
	echo "Reading floppy..."
	dd if=$FD of=$WK/boot.img bs=18k 2> /dev/null
	if [ $? != 0 ]
	then
		echo "Error reading floppy."
		exit 1
	fi
fi

# extracting kernel and drivers

echo "Extracting boot files..."
dd if=$WK/boot.img of=$WK/newboot.img bs=128k count=1 2>/dev/null
dd if=$WK/boot.img of=$WK/boot.tgz bs=128k skip=1 2> /dev/null
rm $WK/boot.img
# the following tar command will end with error
tar xzf $WK/boot.tgz -C $WK 2> /dev/null
chmod -R a+r,u+w $WK/beos

# copy new driver or apply patch to driver

if [ ! "x$COPY" = x ]
then
	echo "Copying driver file."
	cp $DRIVER $WK/$DESTDIR
else
	echo "Applying patch to driver."
	DIR=$WK/$DESTDIR
	export DIR
	NOBACKUP=1
	export NOBACKUP
	if $PATCHSCRIPT $*
	then
		echo "Patch is successfully applied"
	else
		echo "Applying patch failed"
		rm -rf $WK/beos
		exit 1
	fi
fi

# archive files again

echo "Archiving boot files..."
tar czf $WK/boot.tgz -C $WK beos
rm -rf $WK/beos

# merge zbeos and archive

echo "Creating new floppy image..."
cat $WK/boot.tgz >> $WK/newboot.img
rm $WK/boot.tgz

# write to floppy

echo "Insert a blank floppy (write-enabled) and press Enter."
read foo
echo "Writing new floppy..."
dd if=$WK/newboot.img of=$FD bs=18k conv=sync 2> /dev/null
if [ $? != 0 ]
then
	echo "Error writing floppy"
	exit 1
fi
rm $WK/newboot.img

# end

echo "All done."
