
#include <string.h>
#include <stdio.h>
#include "parse.h"


/* FIXME */
static int	ParsePwrParam	(uint8 *buf, float *param)
{
	uint8	*p = buf;
	
	while (*p++ & 0x80);
	return p - buf;
}

static int	ParsePwrDesc	(uint8 *buf, struct PwrDesc_t *PwrDesc)
{
	uint8	*p = buf;
	int		c;
	
	c = *p++;
	if (c & 0x01)
		p += ParsePwrParam (p, &PwrDesc->NomV);
	if (c & 0x02)
		p += ParsePwrParam (p, &PwrDesc->MinV);
	if (c & 0x04)
		p += ParsePwrParam (p, &PwrDesc->MaxV);
	if (c & 0x08)
		p += ParsePwrParam (p, &PwrDesc->StaticI);
	if (c & 0x10)
		p += ParsePwrParam (p, &PwrDesc->AvgI);
	if (c & 0x20)
		p += ParsePwrParam (p, &PwrDesc->PeakI);
	if (c & 0x40)
		p += ParsePwrParam (p, &PwrDesc->PdwnI);
	
	return p - buf;
}

int	ParseConfigEntryTuple	(uint8 *TupleData, int TupleDataLen, struct ParsedConfigEntryTuple_t *parsed)
{
	uint8	*p = TupleData;
	int		c, i;

#if 0
	memset (parsed, 0, sizeof (struct ParsedConfigEntryTuple_t));
#endif
	
	/* TPCE_INDX */
	c = *p++;
#ifdef DEBUG
	printf ("  Configuration Index Byte = %02X\n", c);
#endif
	parsed->ConfigIndex = c & 0x3F;
	parsed->Default = c & 0x40;
	parsed->Intface = c & 0x80;
	
	/* TPCE_IF */
	if (parsed->Intface)
	{
		c = *p++;
#ifdef DEBUG
		printf ("  Interface Descriptor = %02X\n", c);
#endif
		parsed->IFType   = c & 0x0F;
		parsed->BVDAct   = c & 0x10;
		parsed->WPAct    = c & 0x20;
		parsed->ReadyAct = c & 0x40;
		parsed->MWaitReq = c & 0x80;
	}

	/* TPCE_FS */
	c = *p++;
#ifdef DEBUG
	printf ("  Feature Select = %02X\n", c);
#endif
	parsed->PowerSel    = c & 0x03;
	parsed->TimingSel   = c & 0x04;
	parsed->IOSpaceSel  = c & 0x08;
	parsed->IRQSel      = c & 0x10;
	parsed->MemSpaceSel = (c & 0x60) >> 5;
	parsed->MiscSel     = c & 0x80;

	/* TPCE_PD */
	switch (parsed->PowerSel)
	{
	case 1:
		p += ParsePwrDesc (p, &parsed->Vcc);
		break;
	case 2:
		p += ParsePwrDesc (p, &parsed->Vcc);
		p += ParsePwrDesc (p, &parsed->Vpp1);
		parsed->Vpp2 = parsed->Vpp1;
		break;
	case 3:
		p += ParsePwrDesc (p, &parsed->Vcc);
		p += ParsePwrDesc (p, &parsed->Vpp1);
		p += ParsePwrDesc (p, &parsed->Vpp2);
		break;
	}
	
	/* TPCE_TD */
	if (parsed->TimingSel)
	{
		c = *p++;
#ifdef DEBUG
		printf ("    Timing Parameter = %02X\n", c);
#endif
		parsed->WaitScale = c & 0x03;
		parsed->ReadyScale = (c & 0x1C) >> 2;
		parsed->RsvScale = c >> 5;
		if (parsed->WaitScale < 3)
		{
			/* FIXME */
			while (*p++ & 0x80);
		}
		if (parsed->ReadyScale < 7)
		{
			/* FIXME */
			while (*p++ & 0x80);
		}
		if (parsed->RsvScale < 7)
		{
#if 0							/* for REX-5535 */
			/* FIXME */
			while (*p++ & 0x80);
#endif
		}
	}
	
	/* TPCE_IO */
	if (parsed->IOSpaceSel)
	{
		c = *p++;
#ifdef DEBUG
		printf ("    I/O param = %02X\n", c);
#endif
		parsed->IOAddrLines = c & 0x1F;
		parsed->Bus16_8 = (c & 0x60) >> 5;
		parsed->IORange = c & 0x80;
		if (parsed->IORange)
		{
			c = *p++;
			parsed->IOAddrRanges = (c & 0x0F) + 1;
			parsed->IOAddrSize = (c & 0x30) >> 4;
			if (parsed->IOAddrSize == 3) parsed->IOAddrSize = 4;
			parsed->IOLenSize = c >> 6;
			if (parsed->IOLenSize == 3) parsed->IOLenSize = 4;
			for (i = 0; i < parsed->IOAddrRanges; i++)
			{
				uint32	x;
				
				x = 0;
				switch (parsed->IOAddrSize)
				{
				case 4:	x |= p [3] << 24;
						x |= p [2] << 16;
				case 2:	x |= p [1] <<  8;
				case 1:	x |= p [0]      ;
				}
				parsed->IOAddrRange [i].Start = x;
				p += parsed->IOAddrSize;
				
				x = 0;
				switch (parsed->IOLenSize)
				{
				case 4:	x |= p [3] << 24;
						x |= p [2] << 16;
				case 2:	x |= p [1] <<  8;
				case 1:	x |= p [0]      ;
				}
				parsed->IOAddrRange [i].Len = x + 1;
				p += parsed->IOLenSize;
			}
		}
	}

	/* TPCE_IR */
	if (parsed->IRQSel)
	{
		c = *p++;
#ifdef DEBUG
		printf ("    IRQ parameter = %02X\n", c);
#endif
		parsed->Mask = c & 0x10;
		parsed->Level = c & 0x20;
		parsed->Pulse = c & 0x40;
		parsed->Share = c & 0x80;
		if (parsed->Mask)
		{
			parsed->NMI = c & 0x01;
			parsed->IOCk = c & 0x02;
			parsed->BErr = c & 0x04;
			parsed->Vend = c & 0x08;
			parsed->IRQMask = p [0] | (p [1] << 8);
			p += 2;
		}
		else
			parsed->IRQN = c & 0x0F;
	}
	
	/* TPCE_MS */
	switch (parsed->MemSpaceSel)
	{
	case 1:
		parsed->MemWins = 1;
		parsed->MemLenSize = 2;
		parsed->MemAddrSize = 0;
		parsed->HostAddr = 0;
		parsed->WinDesc [0].Len = p [0] | (p [1] << 8);
		p += 2;
		break;
	
	case 2:
		parsed->MemWins = 1;
		parsed->MemLenSize = 2;
		parsed->MemAddrSize = 2;
		parsed->HostAddr = 0;
		parsed->WinDesc [0].Len      = p [0] | (p [1] << 8);
		parsed->WinDesc [0].CardAddr = p [2] | (p [3] << 8);
		p += 4;
		break;
	
	case 3:
		c = *p++;
#ifdef DEBUG
		printf ("    Memory descriptor = %02X\n", c);
#endif
		parsed->MemWins = (c & 0x07) + 1;
		parsed->MemLenSize = (c & 0x18) >> 3;
		parsed->MemAddrSize = (c & 0x60) >> 5;
		parsed->HostAddr = c & 0x80;
#ifdef DEBUG
		printf ("%d wins, len %d bytes, addr %d bytes\n",
			parsed->MemWins,parsed->MemLenSize,parsed->MemAddrSize);
#endif
		for (i = 0; i < parsed->MemWins; i++)
		{
			uint32	x;
			
			x = 0;
			switch (parsed->MemLenSize)
			{
				case 3:	x |= p [2] << 16;
				case 2:	x |= p [1] <<  8;
				case 1:	x |= p [0]      ;
			}
#ifdef DEBUG
			printf ("MemWinLen %d = %08lX\n", i, x);
#endif
			parsed->WinDesc [i].Len = x;
			p += parsed->MemLenSize;
			
			x = 0;
			switch (parsed->MemAddrSize)
			{
				case 3:	x |= p [2] << 16;
				case 2:	x |= p [1] <<  8;
				case 1:	x |= p [0]      ;
			}
#ifdef DEBUG
			printf ("MemWinCard %d = %08lX\n", i, x);
#endif
			parsed->WinDesc [i].CardAddr = x;
			p += parsed->MemAddrSize;
			
			if (parsed->HostAddr)
			{
				x = 0;
				switch (parsed->MemAddrSize)
				{
					case 3:	x |= p [2] << 16;
					case 2:	x |= p [1] <<  8;
					case 1:	x |= p [0]      ;
				}
				parsed->WinDesc [i].HostAddr = x;
				p += parsed->MemAddrSize;
			}
		}
	}

	/* TPCE_MI */
	if (parsed->MiscSel)
	{
		c = *p++;
#ifdef DEBUG
		printf ("  Misc features = %02X\n", c);
#endif
		parsed->MaxTwinCards = c & 0x07;
		parsed->Audio = c & 0x08;
		parsed->ReadOnly = c & 0x10;
		parsed->PwrDown = c & 0x20;
		if (c & 0x80)
		{
			c = *p++;
			parsed->DMAReqSig = (c & 0x0C) >> 2;
			parsed->DMAWidth = c & 0x10;
			if (c & 0x80)
			{
				c = *p++;
				parsed->ThermalMajor = c & 0x7F;
				if (c & 0x80)
				{
					c = *p++;
					parsed->ThermalMinor = c & 0x7F;
				}
			}
		}
	}
	return p - TupleData;
}

#if 0
void	main	(void)
{
	uint8	buf [] = {
#if 0
		/* FAT015 */
		0xC0, 0x40, 0xA1, 0x01, 0x55, 0x08, 0x00, 0x20
		0xC1, 0x41, 0x99, 0x01, 0x55, 0x64, 0xF0, 0xFF, 0xFF, 0x20
		0x82, 0x41, 0x18, 0xEA, 0x61, 0xF0, 0x01, 0x07, 0xF6, 0x03, 0x01, 0xEE
		0x83, 0x41, 0x18, 0xEA, 0x61, 0x70, 0x01, 0x07, 0x76, 0x03, 0x01, 0xEE
		/* PCINS128 */
		0xE0, 0x41, 0x9D, 0x78, 0x26, 0x26, 0x2E, 0x0D, 0xE7, 0x5F, 0xAA, 0x60, 0xF8, 0x03, 0x07, 0x30, 0xFF, 0xFF, 0x20
		0x21, 0x08, 0xAA, 0x60, 0xF8, 0x02, 0x07
		/* XJ1144 */
		0xE0, 0x01, 0x1D, 0x48, 0x6D, 0x2D, 0xFC, 0x14, 0xA0, 0x60, 0xF8, 0x03, 0x07, 0x30, 0x3C, 0x00
		0x21, 0x08, 0xA0, 0x60, 0xF8, 0x02, 0x07
		/* REX-5535 */
		0xE0, 0x81, 0xFD, 0x5F, 0x55, 0xC5, 0x4B, 0xD5, 0x19, 0x86, 0x10, 0x26, 0x45, 0xA0, 0x40, 0x1F, 0x20, 0xFF, 0xFF, 0x28, 0x80, 0x00, 0x20, 0xFF
		0x21, 0x08, 0xAA, 0x60, 0x20, 0x1F, 0xFF
		0x28, 0x08, 0xAA, 0x60, 0x00, 0x01, 0x1F, 0xFF
		/* IBM Ethernet CC II */
		0xC1, 0x81, 0x7E, 0x19, 0x55, 0x15, 0x26, 0x01, 0x0E, 0xFC, 0x33, 0x45, 0x70, 0xFF, 0xFF, 0x48, 0x40, 0x10, 0x01
		/* DE-650 */
		0xE0, 0x81, 0x18, 0x45, 0x30, 0xFC, 0xBE
		/* DC-1P */
		0xE0, 0x01, 0x19, 0x01, 0x55, 0xA3, 0x60, 0xF8, 0x03, 0x07, 0x30, 0xB8, 0x86
		/* PCHD80 */
		0xC0, 0xF0, 0x21, 0x01, 0x55, 0x08, 0x00
		/* joy&midi */
		0xC5, 0x41, 0x39, 0x01, 0x55, 0xAC, 0x61, 0x00, 0x02, 0x00, 0x00, 0x03, 0x01, 0x30, 0xB8, 0x06, 0x10, 0x00
		/* MPS110 */
		0xC8, 0x01, 0x9D, 0x51, 0x55, 0x75, 0x34, 0xFC, 0x32, 0xE0, 0x40, 0x0F, 0x70, 0x28, 0x9C, 0x23
		/* 611S */
		0xE0, 0x41, 0x99, 0x01, 0x55, 0xAB, 0x60, 0xF8, 0x03, 0x07, 0x30, 0xB8, 0x86, 0x20
		/* PHS DATA */
		0xE0, 0xC1, 0x9D, 0x79, 0x55, 0x55, 0x75, 0x06, 0x1D, 0xE8, 0x43, 0x1F, 0xAA, 0x60, 0xF8, 0x03, 0x07, 0x30, 0xBC, 0x86, 0x00
		/* ENW3501*/
		0xE0, 0x81, 0x18, 0x45, 0x30, 0xFC, 0xBE
		/* XJ3288 */
		0xE0, 0x41, 0x99, 0x49, 0x55, 0x26, 0x25, 0xAA, 0x60, 0xF8, 0x03, 0x07, 0x30, 0xFF, 0xFF, 0x28
		/* TWO LINK */
		0xE0, 0x41, 0x9D, 0x68, 0x06, 0x46, 0x25, 0xE7, 0x4F, 0xAA, 0x60, 0xF8, 0x03, 0x07, 0x30, 0xBC, 0x86, 0x08
		/* IBM Token */
		0xE1, 0x81, 0x7D, 0x11, 0x55, 0x36, 0xFC, 0x0B, 0xB0, 0x60, 0x20, 0x0A, 0x07, 0x30, 0xFF, 0xFF, 0x11, 0x20, 0x00, 0x00, 0x01, 0xFF
#endif
	};
	struct ParsedConfigEntryTuple_t	tuple;
	int	n;

	n = ParseConfigEntryTuple (buf, sizeof buf, &tuple);
	printf ("Parsed %d bytes\n", n);
	PrintConfigEntryTuple (&tuple);
}
#endif

