/*
	PC Card library
	Copyright (C) 1998-1999 ITO Takayuki
	
	PC Card generic declarations
*/

#ifndef	_PCMCIA_H
#define	_PCMCIA_H

#define	DEVICE_TYPES	16
#define	SIZE_CODES		8
#define	CONFIG_REGS		5
#define	FUNCTIONS		11

enum CS_Tuple
{
	/* layer 1 tuples */
	CISTPL_NULL				= 0x00,
	CISTPL_DEVICE			= 0x01,
	CISTPL_LONGLINK_CB		= 0x02,
	CISTPL_INDIRECT			= 0x03,
	CISTPL_CFTABLE_ENTRY_CB	= 0x05,
	CISTPL_LONGLINK_MFC		= 0x06,
	CISTPL_BAR				= 0x07,
	CISTPL_PWR_MGMNT		= 0x08,
	CISTPL_CHECKSUM			= 0x10,
	CISTPL_LONGLINK_A		= 0x11,
	CISTPL_LONGLINK_C		= 0x12,
	CISTPL_LINKTARGET		= 0x13,
	CISTPL_NO_LINK			= 0x14,
	CISTPL_VERS_1			= 0x15,
	CISTPL_ALTSTR			= 0x16,
	CISTPL_DEVICE_A			= 0x17,
	CISTPL_JEDEC_C			= 0x18,
	CISTPL_JEDEC_A			= 0x19,
	CISTPL_CONFIG			= 0x1A,
	CISTPL_CFTABLE_ENTRY	= 0x1B,
	CISTPL_DEVICE_OC		= 0x1C,
	CISTPL_DEVICE_OA		= 0x1D,
	CISTPL_DEVICEGEO		= 0x1E,
	CISTPL_DEVICEGEO_A		= 0x1F,
	CISTPL_MANFID			= 0x20,
	CISTPL_FUNCID			= 0x21,
	CISTPL_FUNCE			= 0x22,
	
	/* layer 2/3 tuples */
	CISTPL_SWIL				= 0x23,
	CISTPL_VERS_2			= 0x40,
	CISTPL_FORMAT			= 0x41,
	CISTPL_GEOMETRY			= 0x42,
	CISTPL_BYTEORDER		= 0x43,
	CISTPL_DATE				= 0x44,
	CISTPL_BATTERY			= 0x45,
	CISTPL_ORG				= 0x46,
	CISTPL_FORMAT_A			= 0x47,
	
	/* layer 4 tuples */
	CISTPL_VU_MIN			= 0x80,
	CISTPL_VU_MAX			= 0x8F,
	CISTPL_SPCL				= 0x90,
	
	CISTPL_END				= 0xFF
};

enum DeviceSpeed
{
	DSPEED_NULL		= 0,
	DSPEED_250NS	= 1,
	DSPEED_200NS	= 2,
	DSPEED_150NS	= 3,
	DSPEED_100NS	= 4,
	DSPEED_EXT		= 7
};

enum DeviceType 
{
	DTYPE_NULL		= 0,
	DTYPE_ROM		= 1,
	DTYPE_OTPROM	= 2,
	DTYPE_EPROM		= 3,
	DTYPE_EEPROM	= 4,
	DTYPE_FLASH		= 5,
	DTYPE_SRAM		= 6,
	DTYPE_DRAM		= 7,
	DTYPE_IO		= 13,
	DTYPE_FUNCSPEC	= 13,
	DTYPE_EXTEND	= 14
};

enum FuncID
{
	FUNCID_MULTI	= 0,
	FUNCID_MEMORY	= 1,
	FUNCID_SERIAL	= 2,
	FUNCID_PARALLEL	= 3,
	FUNCID_DISK		= 4,
	FUNCID_VIDEO	= 5,
	FUNCID_NETWORK	= 6,
	FUNCID_AIMS		= 7,
	FUNCID_SCSI		= 8,
	FUNCID_SECURITY	= 9,
	FUNCID_INST		= 10
};

#endif
