#include	"resource.h"

/* resource mask */

void	init_resource_mask	(struct resource_mask *res)
{
	res->mask = 0;
}

void	add_resource_mask (struct resource_mask *res, uint32 mask)
{
	res->mask |= mask;
}

uint32	get_resource_mask (struct resource_mask *res)
{
	return res->mask;
}

void	dump_resource_mask (struct resource_mask *res)
{
	dprintf ("resource mask: 0x%08x\n", res->mask);
}

/* resource list */

void	init_resource_list	(struct resource_list *res)
{
	res->n = 0;
}

void	add_resource_list	(struct resource_list *res, struct range *r)
{
	if (res->n < MAX_RES_LIST)
	{
		res->list [res->n] = *r;
		res->n++;
	}
}

static int	compar (struct range *r1, struct range *r2)
{
	if (r1->start < r2->start)
		return -1;
	if (r1->start > r2->start)
		return 1;
	return 0;
}

static void	sort_resource_list	(struct resource_list *res)
{
	qsort (res->list, res->n, sizeof res->list [0], compar);
}

static bool	overlapped (struct range *r1, struct range *r2)
{
	return !(r1->end < r2->start || r2->end < r1->start);
}

status_t	check_free_resource	(struct resource_list *res, struct range *r)
{
	int	i;

	for (i = 0; i < res->n; i++)
	{
		if (overlapped (&res->list [i], r))
			return B_ERROR;
	}
	return B_OK;
}

void	dump_resource_list	(struct resource_list *res)
{
	int	i;

	dprintf ("resource list begins\n");
	sort_resource_list (res);
	for (i = 0; i < res->n; i++)
		dprintf ("0x%08x - 0x%08x\n", res->list [i].start, res->list [i].end);
	dprintf ("resource list ends\n");
}

