#ifndef _MY_RESOURCE_H_
#define _MY_RESOURCE_H_

#include	<support/SupportDefs.h>

extern struct resource_list	io_list, mem_list;
extern struct resource_mask	irq_mask;

struct resource_mask
{
	uint32	mask;
};

void	init_resource_mask	(struct resource_mask *res);
void	add_resource_mask (struct resource_mask *res, uint32 mask);
uint32	get_resource_mask (struct resource_mask *res);
void	dump_resource_mask (struct resource_mask *res);

struct range
{
	uint32	start, end;
};

#define	MAX_RES_LIST	100

struct resource_list
{
	struct range	list [MAX_RES_LIST];
	int	n;
};

void	init_resource_list	(struct resource_list *res);
void	add_resource_list	(struct resource_list *res, struct range *r);
status_t	check_free_resource	(struct resource_list *res, struct range *r);
void	dump_resource_list	(struct resource_list *res);

#endif
