//
// BeOS bits for bebeeb
// Sets up a BeOS front end, then spawns the
//  emulator as a thread, a la UAE.
// 
// J. Belson	1998.07.05
//

#include <AppKit.h>
#include <InterfaceKit.h>
#include <Path.h>
#include <KernelKit.h>
#include <StorageKit.h>
#include <MediaKit.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <iostream.h>
#include <unistd.h>

typedef unsigned char byteval;



extern "C" {

// Headers we need...
#include "Beeb.h"
#include "Keyboard.h"

// Acess stuff from other files...
extern unsigned long Cells[16];
extern int real_main(int argc, char **argv);
extern char DiskDirectory[];
extern int ChangeDiskDirectory(char *);
extern unsigned char BreakKeypress;
extern unsigned char QuitEmulator;
extern unsigned char Mem[];
extern int SoundEnabled;

// Export these functions...
void BeDrawImageString(int x, int y, unsigned char *text, int len);
void handle_events(void);
void BeSetForeground(int colour);
void BeSetBackground(int colour);
void BeFillRectangle(int x, int y, int width, int height);
int BeGetBytesPerRow(void);
unsigned char *BeImageData(void);
void BePutImage(int Xmin1, int Ymin1, int Xmin2, int Ymin2, int Xsize, int Ysize);
void BeClearScreen();
void BeCheckEvents(void);

void BeSetFontStd(void);
void BeSetFontStdDblL(void);
void BeSetFontStdDblU(void);
void BeSetFontGrc(void);
void BeSetFontGrcDblL(void);
void BeSetFontGrcDblU(void);
void BeSetFontGrs(void);
void BeSetFontGrsDblL(void);
void BeSetFontGrsDblU(void);

void BePlayNote(int channel, unsigned int MidiNote, int volume);
void BeStopNote(int channel);
};


// Include raw font data ...
#include "ttext-std.c"
#include "ttext-std-udh.c"
#include "ttext-std-ldh.c"
#include "ttext-grc.c"
#include "ttext-grc-udh.c"
#include "ttext-grc-ldh.c"
#include "ttext-grs.c"
#include "ttext-grs-udh.c"
#include "ttext-grs-ldh.c"


// Message names...
const uint32 MSG_RESET	= 'boot';
const uint32 MSG_PREFS	= 'pref';
const uint32 MSG_MOUNT	= 'mont';
const uint32 MSG_QUIT	= 'quit';
const uint32 MSG_ABOUT	= 'abut';
const uint32 MSG_DISK_CHANGED = 'chng';

// Some constants...
const int WIDTH			= 640;		// Width of display window
const int HEIGHT		= 640;
const int CHAR_WIDTH	= 12;		// Size of a teletext character
const int CHAR_HEIGHT	= 19;
const int OFF_X			= ((WIDTH - 40*CHAR_WIDTH)/2);
const int OFF_Y			= ((525 - 26*CHAR_HEIGHT)/2);


// Shamelessly lifted from Screen.c
static int	rgb_values [ 8 ][ 3 ] =
{
	{ 0x00, 0x00, 0x00 },		/* 0 = Black */
	{ 0xff, 0x00, 0x00 },		/* 1 = Red */
	{ 0x00, 0xff, 0x00 },		/* 2 = Green */
	{ 0xff, 0xff, 0x00 },		/* 3 = Yellow */
	{ 0x00, 0x00, 0xff },		/* 4 = Blue */
	{ 0xff, 0x00, 0xff },		/* 5 = Magenta */
	{ 0x00, 0xff, 0xff },		/* 6 = Cyan */
	{ 0xff, 0xff, 0xff }		/* 7 = White */
};

// Sound patches for audio output
int patch [ 3 ][ 51 ] = {
	{ 
		0x53, 0x42, 0x49, 0x1a, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x11, 0x00,
		0xf0, 0xf0, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00
	},
	{
		0x53, 0x42, 0x49, 0x1a, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x87, 0x25, 0x80, 0x88,
		0xff, 0xff, 0x00, 0x05, 0x00, 0x00, 0x0e, 0x00,
		0x00, 0x00, 0x00
	},
	{
		0x53, 0x42, 0x49, 0x1a, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x87, 0x25, 0x80, 0x88,
		0xff, 0xff, 0x00, 0x05, 0x00, 0x00, 0x0e, 0x00,
		0x00, 0x00, 0x00
	}
};


// Stuff for disk directory selection..
BEntry AppDirectory;
BFilePanel *disk_dir;
bool request_disk_change;
bool restart_thread;

// Stuff for for teletext display
int	ttext_foreground;
int ttext_background;
unsigned short *current_font;





//
// Class to handle audio output...
//
class bbc_audio {

public:
	~bbc_audio();
	int init(void);
	bool play_next(char *buffer, long count);
	void play_note(int channel, unsigned int MidiNote, int volume);
	void stop_note(int channel);

private:
	enum { NUM_CHANNELS = 4,
			SAMPLE_RATE = 22010 };
	// Single frame from audio stream
	struct standard_frame { 
		int16 left, right;
	}; 
	typedef struct standard_frame standard_frame; 
	BSubscriber *subscriber;
	BDACStream *stream;

	struct str_channel_info {
		bool playing;		// Is channel active?
		int step;			// How often to output a sample
		int count;			// # samples output for note
		int volume;			// Volume (1 - 15)
		bool state;			// Indicates +volume or -volume
	} channel_info[NUM_CHANNELS];

	static bool stream_func(void *userData, char *buffer, size_t count, void *header);
};



//
// Creates bitmap and handles rendering to it
//
class BitmapView : public BView {
public:
	BitmapView(BRect frame);
	virtual void Draw(BRect update);
	virtual void KeyDown(const char *bytes, int32 numBytes);
	virtual void KeyUp(const char *bytes, int32 numBytes);

	void DrawImageString(int x, int y, unsigned char *text, int len);
	void FillRect(int x, int y, int width, int height);
	void ClearScreen(void);
	int GetBytesPerRow(void) { return bytes_per_row; };
	void PutImage(int Xsize, int Ysize);
	void CheckEvents(void);

	unsigned char *GetBitmapData(void) { return bitmap_data; }
	BBitmap *GetBitmap(void) { return the_bitmap[current]; }

	// Switch buffers...
	void Switch(void) { };

private:
	bool current;
	BBitmap *the_bitmap[2];
	int bytes_per_row;
	unsigned char *bitmap_data;
	
	// Called from KeyDown() and KeyUp()
	unsigned char switch_key(const char *bytes);
};




//
// Main application window
//
class bebeeb_window : public BWindow {
public:
	bebeeb_window(BRect frame);
	virtual bool QuitRequested(void);
	virtual void MessageReceived(BMessage *msg);

private:

};



//
// Application
//
class bebeeb : public BApplication {
public:
	bebeeb();
	virtual void ReadyToRun(void);
	virtual bool QuitRequested(void);
	void RestartThread(void);

private:
	static long thread_func(void *obj);
	thread_id the_thread;			// id of our spawned thread
};

