/*********************************************************************
	main.cpp
	
	This file contains the complete implementation of a sample app
	to demonstrate usage of the notification library.
	
	Who	When		What
	GJW	19980718	Initial coding and commenting
	GJW	19990215	Removed call to defunct initialization function
					in notification library
*********************************************************************/

//	Private Headers
#include <Application.h>
#include <Window.h>
#include "Notification.h"

//	Private Classes
class WinTest : public BWindow {
public:
	//	Construction
	WinTest(void);
	virtual ~WinTest(void);
	
	//	Overrides
	virtual void Quit(void);
	virtual void WindowActivated(bool inActive);
};

//	Private Prototypes
static int32 notify_thread(void* inData);


/*********************************************************************
	WinTest
	Args:	<none>
	Returns:	<none>
	The default constructor creates an empty window for demonstration
	purposes.
*********************************************************************/
WinTest::WinTest(void)
	: BWindow(BRect(100,75,299,149),"Notifier",B_TITLED_WINDOW,0)
{
	/* This space intentionally left blank. */
}

/*********************************************************************
	~WinTest
	Args:	<none>
	Returns:	<none>
	The destructor is empty.
*********************************************************************/
WinTest::~WinTest(void)
{
	/* This space intentionally left blank. */
}

#if 0
#pragma mark -
#endif

/*********************************************************************
	Quit
	Args:	<none>
	Returns:	<none>
	We override BWindow::Quit to suggest that the application should
	go away when the window is closed.
*********************************************************************/
void WinTest::Quit(void)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	BWindow::Quit();
}

/*********************************************************************
	WindowActivated
	Args:	inActive - indicates whether the window is activating
	Returns:	<none>
	The meat of the sample code. This function posts a notification
	whenever the window is deactivated. Notice that the developer
	has no real control over the nature of the notification. It's
	all up to the user.
*********************************************************************/
void WinTest::WindowActivated(bool inActive)
{
	//	If we're being activated, just skip out
	if(inActive) return;

	//	Spawn a thread that will notify the user in a little while
	thread_id theThread = spawn_thread(notify_thread,"notifier",B_NORMAL_PRIORITY,NULL);
	resume_thread(theThread);
}

#if 0
#pragma mark -
#endif

/*********************************************************************
	main
	Args:	<none>
	Returns:	<none>
	Your standard main function to kick off the program.
*********************************************************************/
int main(void)
{
	//	Create the application object
	BApplication app("application/x-vnd.Bastion-notifier");
	
	//	Create the test window
	WinTest* win = new WinTest;
	win->Show();

	//	Run the app to completion and exit
	app.Run();
	return B_NO_ERROR;
}

/*********************************************************************
	notify_thread
	Args:	inData - a pointer for data passed into the thread
	Returns:	0
	This thread sleeps for a couple of seconds and then posts a 
	notification for the user.
*********************************************************************/
int32 notify_thread(void* /*inData*/)
{
	(void)snooze(2000000);
	post_notification();
	return 0;
}
