#include <InterfaceKit.h>
#include <StorageKit.h>

#include "PrinterSetupWindow.h"

PrinterSetupWindow::PrinterSetupWindow(char * printer_name)
	: BWindow(BRect(0,0,300,300), printer_name, B_TITLED_WINDOW_LOOK,
 			B_MODAL_APP_WINDOW_FEEL, B_NOT_ZOOMABLE)
{
	m_exit_sem 		= create_sem(0, "PrinterSetup");
	m_result 		= B_ERROR;
	m_printer_name 	= printer_name;

	// ---- Ok, build a default job setup user interface
	BRect			r;
	BButton * 		button;
	float			x, y, w, h;
	font_height		fh;
	
	r = Bounds();

	// add a *dialog* background
	BBox * panel = new BBox(r, "top_panel", B_FOLLOW_ALL, 
					B_WILL_DRAW | B_FRAME_EVENTS | B_NAVIGABLE_JUMP,
					B_PLAIN_BORDER);


#define INTER_SPACE	(8)
#define HORZ_MARGIN	(10)
#define VERT_MARGIN	(10)

	x = HORZ_MARGIN;
	y = VERT_MARGIN;

	// add a label before the list
#define MODEL_LABEL		"Printer model"	

	be_plain_font->GetHeight(&fh);

	w = Bounds().Width();
	w -= 2 * HORZ_MARGIN;
	h = 150;
	
	BBox * model_group = new BBox(BRect(x, y, x+w, y+h), "model_group", B_FOLLOW_ALL_SIDES);
	model_group->SetLabel(MODEL_LABEL);
	
	BRect rlv = model_group->Bounds();
	
	rlv.InsetBy(HORZ_MARGIN, VERT_MARGIN);
	rlv.top 	+= fh.ascent + fh.descent + fh.leading;
	rlv.right	-= B_V_SCROLL_BAR_WIDTH;
	m_model_list		= new BListView(rlv, "model_list",
											B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL_SIDES );
										
	BScrollView * sv	= new BScrollView( "model_list_scrollview", m_model_list,
											B_FOLLOW_ALL_SIDES,	B_WILL_DRAW | B_FRAME_EVENTS, false, true );
	model_group->AddChild(sv);
	
	panel->AddChild(model_group);

	y += (h + INTER_SPACE);

	x = r.right - HORZ_MARGIN;

	// add a "OK" button, and make it default
	m_ok_button 	= new BButton(BRect(x, y, x + 400, y), NULL, "OK", new BMessage(OK_MSG), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	m_ok_button->ResizeToPreferred();
	m_ok_button->GetPreferredSize(&w, &h);
	x -= w;
	m_ok_button->MoveTo(x, y);
	m_ok_button->MakeDefault(true);
	m_ok_button->SetEnabled(false);

	panel->AddChild(m_ok_button);

	x -= INTER_SPACE;

	// add a "Cancel button	
	button 	= new BButton(BRect(x, y, x + 400, y), NULL, "Cancel", new BMessage(CANCEL_MSG), B_FOLLOW_RIGHT | B_FOLLOW_BOTTOM);
	button->ResizeToPreferred();
	button->GetPreferredSize(&w, &h);
	x -= w;
	button->MoveTo(x, y);
	panel->AddChild(button);

	y += (h + INTER_SPACE);

	panel->ResizeTo(Bounds().Width(), y);
	ResizeTo(Bounds().Width(), y);
	
	float minWidth, maxWidth, minHeight, maxHeight;

	GetSizeLimits(&minWidth, &maxWidth, &minHeight, &maxHeight);
	SetSizeLimits(panel->Frame().Width(), panel->Frame().Width(),
				  panel->Frame().Height(), maxHeight);

	// Finally, add our panel to window
	AddChild(panel);

	BDirectory	Folder;
	BEntry		entry;
	
	Folder.SetTo ( "/boot/beos/etc/bubblejet" );
	if ( Folder.InitCheck() != B_OK )
		return;
		
	while ( Folder.GetNextEntry ( &entry ) != B_ENTRY_NOT_FOUND )
		{
		char	name[B_FILE_NAME_LENGTH];
		if ( entry.GetName(name) == B_NO_ERROR )
			m_model_list->AddItem (new BStringItem(name));
		};

	m_model_list->SetSelectionMessage(new BMessage(MODEL_MSG));
	m_model_list->SetInvocationMessage(new BMessage(OK_MSG));
}



PrinterSetupWindow::~PrinterSetupWindow()
{
	delete_sem(m_exit_sem);
}



bool PrinterSetupWindow::QuitRequested()
{
	release_sem(m_exit_sem);
	return true;
}


void PrinterSetupWindow::MessageReceived(BMessage * msg)
{
	switch (msg->what)
		{
		case OK_MSG:
			{
			// Test model selection (if any), save it in printer_name node and return
			BNode  	spool_dir;
			BPath *	path;

			if (m_model_list->CurrentSelection() < 0)
				break;

			BStringItem * item = dynamic_cast<BStringItem*>
										(m_model_list->ItemAt(m_model_list->CurrentSelection()));
			if ( ! item )
				break;

			path = new BPath();

			find_directory(B_USER_SETTINGS_DIRECTORY, path);
			path->Append("printers");
			path->Append(m_printer_name);

			spool_dir.SetTo(path->Path());
			delete path;

			if (spool_dir.InitCheck() != B_OK )
				{
				BAlert * alert = new BAlert("Uh oh!", "Couldn't find printer spool directory.", "OK");
				alert->Go();
				}
			else
				{			
				spool_dir.WriteAttr("printer_model", B_STRING_TYPE, 0, item->Text(), strlen(item->Text()));
				m_result = B_OK;
				};
			
			release_sem(m_exit_sem);
			break;
			}
		
		case CANCEL_MSG:
			m_result = B_ERROR;
			release_sem(m_exit_sem);
			break;
		
		case MODEL_MSG:
			m_ok_button->SetEnabled((m_model_list->CurrentSelection() >= 0));
			break;
		
		default:
			inherited::MessageReceived(msg);
			break;
		};
}


status_t PrinterSetupWindow::Go()
{
	MoveTo(300,300);
	Show();
	acquire_sem(m_exit_sem);
	Lock();
	Quit();

	return m_result;
}
