/* 
	es1370.h - Defines for the Ensoniq AudioPCI ES1370 device.

    Copyright (C) 1998 HockYiung Huang (leclec@pacific.net.sg)
    Port to R4 (C) 1999 Marc Schefer (mschefer@iprolink.ch)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _ES1370_H_
#define _ES1370_H_

/* how our device is uniquely identified */

#define ES1370_VENDOR_ID	0x1274
#define ES1370_DEVICE_ID	0x5000

/* control codes implemented by the driver */

enum {
  SOUND_GET_PARAMS = B_DEVICE_OP_CODES_END,
  SOUND_SET_PARAMS,
  SOUND_SET_PLAYBACK_COMPLETION_SEM,
  SOUND_SET_CAPTURE_COMPLETION_SEM,
  SOUND_RESERVED_1,   /* unused */
  SOUND_RESERVED_2,   /* unused */
  SOUND_DEBUG_ON,     /* unused */
  SOUND_DEBUG_OFF,    /* unused */
  SOUND_WRITE_BUFFER,
  SOUND_READ_BUFFER,
  SOUND_LOCK_FOR_DMA
};


enum { // adc source
  line = 0, cd, mic, loopback
};

enum { // sample rate
  kHz_8_0 = 0, kHz_5_51, kHz_16_0, kHz_11_025, kHz_27_42,
  kHz_18_9, kHz_32_0, kHz_22_05, kHz_37_8 = 9,
  kHz_44_1 = 11, kHz_48_0, kHz_33_075, kHz_9_6, kHz_6_62
};

uint32 sample_rate_table[] = {
  8000, 	5510, 	16000,	11025, 	27420,
  18900,	32000,	22050,	0,		37800,
  0,		44100,	48000,	33075,	9600,	6620
};
  	
//enum sample_format {};  /* obsolete */

struct channel {
  uint32 adc_source;
       /* adc input source */
  char adc_gain;
       /* 0..15 adc gain, in 1.5 dB steps */
  char mic_gain_enable;
       /* non-zero enables 20 dB MIC input gain */
  char cd_mix_gain;
       /* 0..31 cd mix to output gain in -1.5dB steps */
  char cd_mix_mute;
       /* non-zero mutes cd mix */
  char aux2_mix_gain;
       /* unused */
  char aux2_mix_mute;
       /* unused */
  char line_mix_gain;
       /* 0..31 line mix to output gain in -1.5dB steps */
  char line_mix_mute;
       /* non-zero mutes line mix */
  char dac_attn;
       /* 0..61 dac attenuation, in -1.5 dB steps */
  char dac_mute;
       /* non-zero mutes dac output */
  char reserved_1;
  char reserved_2;
};

typedef struct sound_setup {
  struct channel left;
       /* left channel setup */
  struct channel right; 
       /* right channel setup */
  uint32 sample_rate;
       /* sample rate */
  uint32 playback_format;
       /* ignore (always 16bit-linear) */
  uint32 capture_format;
       /* ignore (always 16bit-linear) */
  char dither_enable;
       /* non-zero enables dither on 16 =&gt; 8 bit */
  char mic_attn;
       /* 0..64 mic input level */
  char mic_enable;
       /* non-zero enables mic input */
  char output_boost;
       /* ignore (always on) */
  char highpass_enable;
       /* ignore (always on) */
  char mono_gain;
       /* 0..64 mono speaker gain */
  char mono_mute;
       /* non-zero mutes speaker */
} sound_setup;

typedef struct {
  int32 buffer_number;
  int32 subscriber_count;
  bigtime_t time;
  int32 reserved_1;
  int32 reserved_2;
  bigtime_t sample_clock;
} audio_buffer_header;

enum {
  STATE_RUN = 0,
  STATE_PAUSE
};

/* the stream */
typedef struct {
	sem_id			completion_sem;			/* completion semaphore */
	uint32			state;
	uint32			sample_rate;
	physical_entry	scatter [2];
	int 			scat_index;
	sem_id			hw_lock;
	area_id			transfer_area;
	void *			data;
	uint32			offset;
	bigtime_t		time;
	bigtime_t		sample_clock;
	//int64			playback_total;
} stream; 

/* the 'cookie' used to keep track of each logical device */
typedef struct {
	pci_info		pci;			/* pci info for this device */
	sound_setup	*	ss;				/* -> sound setup */
	int				id;				/* logical device id */
	stream			playback;		/* playback stream */
	int32			write_count;	/* num of write buffer request pending*/
	stream			capture;		/* capture stream */
	int32			read_count;		/* num of read buffer request pending */
} dev_info;

#endif // _ES1370_H_
