/******************************************************************************
*
*   Copyright P.J.Ruczynski 1990
*   This software is free for redistribution and re-use as long as this
*   copyright is included in all source files. This software is supplied
*   as is and no responsibilty is taken by the author for any problems
*   arising from this code.
*
* File name		-  hexprint.h
*
* Module name		-  HEXPRINT
*
* Author		-  P.J.Ruczynski	<pjr@pyra.co.uk>
*
* Second Release	-  31 May 1990 (V1.6)
* First Release		-  16 Feb 1990 (V1.4)
*
* Version number	-  1.6
*
* Description		-  This file contains definitions required by the 
*			   hexprint routine.
*
*			Revision List
*
* pjr	02.08.89	Changed the bcopy and bcmp routines to use defines defined
*			in hexprint.h and controlled by compilation flag 'ATT'. With this
*			defined att routines are used, default means bsd routines are used.
*			Note that the compression stuff uses BCMP and BCOPY.
*
* pjr	15.05.90	Added octal and decimal output formatting. See hexprint.c
*			for a fuller explanation.
*
******************************************************************************/

#define	TRUE		1
#define	FALSE		0
#define	H_SLEN		16

#ifdef ATT
#define BCMP memcmp
#define BCOPY(a,b,c) memcpy(b,a,c)
#else /* ucb */
#define BCMP bcmp
#define BCOPY bcopy
#endif

#define ZOCTALO		"%05o  "	/* leading zero printf format for offsets */
#define ZOCTALD		"%03o "		/* leading zero printf format for the dump */
#define OCTALO		"%5o  "		/* printf format for offsets */
#define OCTALD		"%3o "		/* printf format for the dump */
#define OCTALP		"    "		/* printf format for padding to ascii */

#define ZDECIMALO	"%05d  "	/* leading zero printf format for offsets */
#define ZDECIMALD	"%03d "		/* leading zero printf format for the dump */
#define DECIMALO	"%5d  "		/* printf format for offsets */
#define DECIMALD	"%3d "		/* printf format for the dump */
#define DECIMALP	"    "		/* printf format for padding to ascii */

#define ZHEXO		"%05x  "	/* leading zero printf format for offsets */
#define ZHEXD		"%02x "		/* leading zero printf format for the dump */
#define HEXO		"%5x  "		/* printf format for offsets */
#define HEXD		"%2x "		/* printf format for the dump */
#define HEXP		"   "		/* printf format for padding to ascii */
