//  inflating: ifsega/saturn.c
//
//	device driver for I/O data Co. IF-SEGA/ISA and IF-SEGA/PCI/2
//
//  Install directory      : /boot/home/config/add-ons/kernel/drivers/bin
//  Create Link file under : /boot/home/config/add-ons/kernel/drivers/dev/joystick

//  Copyright (C) 2000 Jun Suzuki & Takayuki Ito

#include <drivers/KernelExport.h>
#include <drivers/module.h>
#include <kernel/OS.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include "joystick_driver.h"
#include "ifsega.h"

/** "configure" might change the "info" if it auto-detects a device */

static int saturn_configure
(int port, joystick_module_info * info, size_t size, void ** out_cookie)
{
	dprintf ("saturn: configure()\n");
	dprintf ("saturn: module_name = %s\n", info->module_name);
	dprintf ("saturn: device_name = %s\n", info->device_name);
	dprintf ("saturn: %d axes, %d buttons, %d hats\n",
		info->num_axes, info->num_buttons, info->num_hats);
	return B_ERROR;
}

/** "read" actual data from device into "data" */
static int saturn_read
(void * cookie, int port, extended_joystick * data, size_t size)
{
	int act, a, b;
	bool xinv;
	bool yinv;
	struct ifsega_status *io = (struct ifsega_status *) cookie;

	act = 0;

	data->timestamp = system_time ();
	
	//SACBRXYZL---  => -------SZYXCBALR

	switch (io->stick[act].type)
	{
		case 0x03:
			/* pointing devices */
			a = io->stick[act].ax;
			b = io->stick[act].ay;

			data->axes [0] = a * 256;
			data->axes [1] = -b * 256;
			data->axes [2] = 0;
			data->axes [3] = 0;
			data->axes [4] = 0;
			data->axes [5] = 0;
			//SACBRXYZL---  => ------------SCBA
			data->buttons = ~(
				(io->stick[act].pad & 0x0800) >> 8| //S 
	 			(io->stick[act].pad & 0x0400) >> 10| //A 
	 			(io->stick[act].pad & 0x0200) >> 7| //C 
	 			(io->stick[act].pad & 0x0100) >> 7); //B
			break;
		case 0x05:
			/* analog devices */ 
			data->axes [0] = ((io->stick[act].pad & 0x8000) ? false:true) * 32767 + ((io->stick[act].pad & 0x4000) ? false:true) * -32767;
			data->axes [1] = ((io->stick[act].pad & 0x2000) ? false:true) * 32767 + ((io->stick[act].pad & 0x1000) ? false:true) * -32767;
			data->axes [2] = (io->stick[act].ax - 0x80) * 256;
			data->axes [3] = (io->stick[act].ay - 0x80) * 256;
			data->axes [4] = io->stick[act].ar * 128;
			data->axes [5] = io->stick[act].al * 128;
			//SACBRXYZL---  => -------SZYXCBALR
			data->buttons = ~(
	 			(io->stick[act].pad & 0x0800) >> 3| //S 
	 			(io->stick[act].pad & 0x0400) >> 8| //A 
		 		(io->stick[act].pad & 0x0200) >> 5| //C 
				(io->stick[act].pad & 0x0100) >> 5| //B 
				(io->stick[act].pad & 0x0080) >> 7| //R
				(io->stick[act].pad & 0x0040) >> 1| //X
				(io->stick[act].pad & 0x0020) << 1| //Y
				(io->stick[act].pad & 0x0010) << 3| //Z
				(io->stick[act].pad & 0x0008) >> 2); //L
			break;
		case 0x0B:
			/* digital devices */ 
			data->axes [0] = ((io->stick[act].pad & 0x8000) ? false:true) * 32767 + ((io->stick[act].pad & 0x4000) ? false:true) * -32767;
			data->axes [1] = ((io->stick[act].pad & 0x2000) ? false:true) * 32767 + ((io->stick[act].pad & 0x1000) ? false:true) * -32767;
			data->axes [2] = 0;
			data->axes [3] = 0;
			data->axes [4] = 0;
			data->axes [5] = 0;
			data->buttons = ~(
			//SACBRXYZL---  => -------SZYXCBALR
	 			(io->stick[act].pad & 0x0800) >> 3| //S 
	 			(io->stick[act].pad & 0x0400) >> 8| //A 
		 		(io->stick[act].pad & 0x0200) >> 5| //C 
				(io->stick[act].pad & 0x0100) >> 5| //B 
				(io->stick[act].pad & 0x0080) >> 7| //R
				(io->stick[act].pad & 0x0040) >> 1| //X
				(io->stick[act].pad & 0x0020) << 1| //Y
				(io->stick[act].pad & 0x0010) << 3| //Z
				(io->stick[act].pad & 0x0008) >> 2); //L
	
			break;
		case 0x0F:
			data->axes [0] = 0;
			data->axes [1] = 0;
			data->axes [2] = 0;
			data->axes [3] = 0;
			data->axes [4] = 0;
			data->axes [5] = 0;
			data->buttons = 0;
	}
	return size;
}

/** "crumble" the cookie (deallocate) when done */
static int saturn_crumble (void * cookie, int port)
{
	dprintf ("saturn: crumble()\n");
	return B_OK;
}

/** "force" tells the joystick to exert force on the same axes as input for the specified duration */
static int saturn_force
(void * cookie, int port, bigtime_t duration, extended_joystick * force, size_t size)
{
	dprintf ("saturn: force()\n");
	return B_ERROR;
}

static status_t std_ops (int32 op, ...)
{
	switch (op)
	{
	case B_MODULE_INIT:
		dprintf ("saturn: B_MODULE_INIT\n");
		return B_OK;
	case B_MODULE_UNINIT:
		dprintf ("saturn: B_MODULE_UNINIT\n");
		return B_OK;
	default:
		dprintf ("saturn: std_ops (%d)\n", op);
		return B_ERROR;
	}
}

static joystick_module saturn_info =
{
	/* module_info minfo = */
	{
		"media/joy/saturn/v2", 0, std_ops
	},
	saturn_configure,
	saturn_read,
	saturn_crumble,
	saturn_force,
	0
};

_EXPORT module_info *modules [] =
{
	(module_info *) &saturn_info, NULL
};
