//  inflating: ifsegaView.cpp
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include "ifsegaApp.h"
#include "ifsegaView.h"
#include "ifsega.h"

int   P1,P2;
char  buf[256]="";

int tt = 0;

TifsegaView::TifsegaView( BRect vframe ):BView( vframe, "ifsegaView",B_FOLLOW_ALL,B_WILL_DRAW | B_PULSE_NEEDED)
{
BRect frame;
	int i;

	frame.Set(20,20, 450, 35);
	Device = new BStringView(frame,"TEXT","",B_FOLLOW_LEFT | B_FOLLOW_TOP,B_WILL_DRAW );
	AddChild(Device);
	for (i = 0; i < 24; i++) {
		frame.Set(20,50 + 20 * i, 450, 65 + 20 * i);
		Display[i] = new BStringView(frame,"TEXT","",B_FOLLOW_LEFT | B_FOLLOW_TOP,B_WILL_DRAW );
		AddChild(Display[i]);
	}
 	P1 = open("/dev/joystick/ifsega/0", O_RDWR);
 	P2 = open("/dev/joystick/ifsega/1", O_RDWR);
}

TifsegaView::~TifsegaView()
{
	close(P1);
	close(P2);
}

void TifsegaView::Pulse()
{

struct ifsega_status if0;
int i, n0, n1;
int bs, ba, bb, bc, bx, by, bz, br, bl, dl, dr, du, dd;

	ioctl(P1, GET_PORTDATA, &if0);
	n0 = if0.num;


	if (n0 > 0) { 
		for (i = 0; i < 6; i++) {
	 			bs = ((if0.stick[i].pad & 0x0800) ? false:true); 
	 			ba = ((if0.stick[i].pad & 0x0400) ? false:true); 
		 		bc = ((if0.stick[i].pad & 0x0200) ? false:true); 
				bb = ((if0.stick[i].pad & 0x0100) ? false:true); 
				dr = ((if0.stick[i].pad & 0x8000) ? false:true);
				dl = ((if0.stick[i].pad & 0x4000) ? false:true);
				dd = ((if0.stick[i].pad & 0x2000) ? false:true);
				du = ((if0.stick[i].pad & 0x1000) ? false:true);
				br = ((if0.stick[i].pad & 0x0080) ? false:true);
				bx = ((if0.stick[i].pad & 0x0040) ? false:true);
				by = ((if0.stick[i].pad & 0x0020) ? false:true);
				bz = ((if0.stick[i].pad & 0x0010) ? false:true);
				bl = ((if0.stick[i].pad & 0x0008) ? false:true);
				
				sprintf(buf,"PORT0-%d TYPE:%2.2X DEV:%2.2X PAD:%4.4X AX:%2.2X AY:%2.2X AL:%2.2X AR:%2.2X\n"
    			,i+1,if0.stick[i].type, if0.stick[i].dev, if0.stick[i].pad, if0.stick[i].ax, if0.stick[i].ay, if0.stick[i].al, if0.stick[i].ar);
	  			Display[i * 2]->SetText(buf);

				sprintf(buf," LEFT:%d RIGHT:%d DOWN:%d UP:%d START:%d A:%d B:%d C:%d X:%d Y:%d Z:%d R:%d L:%d\n",dl,dr,dd,du,bs,ba,bb,bc,bx,by,bz,br,bl);
				Display[i * 2 + 1]->SetText(buf);
		}
	} else {
		i = 0;
	 			bs = ((if0.stick[i].pad & 0x0800) ? false:true); 
	 			ba = ((if0.stick[i].pad & 0x0400) ? false:true); 
		 		bc = ((if0.stick[i].pad & 0x0200) ? false:true); 
				bb = ((if0.stick[i].pad & 0x0100) ? false:true); 
				dr = ((if0.stick[i].pad & 0x8000) ? false:true);
				dl = ((if0.stick[i].pad & 0x4000) ? false:true);
				dd = ((if0.stick[i].pad & 0x2000) ? false:true);
				du = ((if0.stick[i].pad & 0x1000) ? false:true);
				br = ((if0.stick[i].pad & 0x0080) ? false:true);
				bx = ((if0.stick[i].pad & 0x0040) ? false:true);
				by = ((if0.stick[i].pad & 0x0020) ? false:true);
				bz = ((if0.stick[i].pad & 0x0010) ? false:true);
				bl = ((if0.stick[i].pad & 0x0008) ? false:true);

			sprintf(buf,"PORT0-%d TYPE:%2.2X DEV:%2.2X PAD:%4.4X AX:%2.2X AY:%2.2X AL:%2.2X AR:%2.2X\n"
   			,i + 1,if0.stick[i].type, if0.stick[i].dev, if0.stick[i].pad, if0.stick[i].ax, if0.stick[i].ay, if0.stick[i].al, if0.stick[i].ar);
 			Display[i * 2]->SetText(buf);
			sprintf(buf," LEFT:%d RIGHT:%d DOWN:%d UP:%d START:%d A:%d B:%d C:%d X:%d Y:%d Z:%d R:%d L:%d\n",dl,dr,dd,du,bs,ba,bb,bc,bx,by,bz,br,bl);
 			Display[i * 2 + 1]->SetText(buf);
		for (i = 1; i < 6; i++) {
 			Display[i * 2]->SetText("\n");
 			Display[i * 2 + 1]->SetText("\n");
		}

	}	
	
	ioctl(P2, GET_PORTDATA, &if0);
	n1 = if0.num;

	if (n1 > 0) { 
		for (i = 0; i < 6; i++) {
	 			bs = ((if0.stick[i].pad & 0x0800) ? false:true); 
	 			ba = ((if0.stick[i].pad & 0x0400) ? false:true); 
		 		bc = ((if0.stick[i].pad & 0x0200) ? false:true); 
				bb = ((if0.stick[i].pad & 0x0100) ? false:true); 
				dr = ((if0.stick[i].pad & 0x8000) ? false:true);
				dl = ((if0.stick[i].pad & 0x4000) ? false:true);
				dd = ((if0.stick[i].pad & 0x2000) ? false:true);
				du = ((if0.stick[i].pad & 0x1000) ? false:true);
				bl = ((if0.stick[i].pad & 0x0080) ? false:true);
				bx = ((if0.stick[i].pad & 0x0040) ? false:true);
				by = ((if0.stick[i].pad & 0x0020) ? false:true);
				bz = ((if0.stick[i].pad & 0x0010) ? false:true);
				br = ((if0.stick[i].pad & 0x0008) ? false:true);
				
				sprintf(buf,"PORT1-%d TYPE:%2.2X DEV:%2.2X PAD:%4.4X AX:%2.2X AY:%2.2X AL:%2.2X AR:%2.2X\n"
    			,i+1,if0.stick[i].type, if0.stick[i].dev, if0.stick[i].pad, if0.stick[i].ax, if0.stick[i].ay, if0.stick[i].al, if0.stick[i].ar);
	  			Display[i * 2 + 12]->SetText(buf);

				sprintf(buf," LEFT:%d RIGHT:%d DOWN:%d UP:%d START:%d A:%d B:%d C:%d X:%d Y:%d Z:%d R:%d L:%d\n",dl,dr,dd,du,bs,ba,bb,bc,bx,by,bz,br,bl);
				Display[i * 2 + 13]->SetText(buf);
		}
	} else {
		i = 0;
	 			bs = ((if0.stick[i].pad & 0x0800) ? false:true); 
	 			ba = ((if0.stick[i].pad & 0x0400) ? false:true); 
		 		bc = ((if0.stick[i].pad & 0x0200) ? false:true); 
				bb = ((if0.stick[i].pad & 0x0100) ? false:true); 
				dr = ((if0.stick[i].pad & 0x8000) ? false:true);
				dl = ((if0.stick[i].pad & 0x4000) ? false:true);
				dd = ((if0.stick[i].pad & 0x2000) ? false:true);
				du = ((if0.stick[i].pad & 0x1000) ? false:true);
				bl = ((if0.stick[i].pad & 0x0080) ? false:true);
				bx = ((if0.stick[i].pad & 0x0040) ? false:true);
				by = ((if0.stick[i].pad & 0x0020) ? false:true);
				bz = ((if0.stick[i].pad & 0x0010) ? false:true);
				br = ((if0.stick[i].pad & 0x0008) ? false:true);

			sprintf(buf,"PORT1-%d TYPE:%2.2X DEV:%2.2X PAD:%4.4X AX:%2.2X AY:%2.2X AL:%2.2X AR:%2.2X\n"
   			,i + 1,if0.stick[i].type, if0.stick[i].dev, if0.stick[i].pad, if0.stick[i].ax, if0.stick[i].ay, if0.stick[i].al, if0.stick[i].ar);
 			Display[i * 2 + 12]->SetText(buf);
			sprintf(buf," LEFT:%d RIGHT:%d DOWN:%d UP:%d START:%d A:%d B:%d C:%d X:%d Y:%d Z:%d R:%d L:%d\n",dl,dr,dd,du,bs,ba,bb,bc,bx,by,bz,br,bl);
 			Display[i * 2 + 13]->SetText(buf);
		for (i = 1; i < 6; i++) {
 			Display[i * 2 + 12]->SetText("\n");
 			Display[i * 2 + 13]->SetText("\n");
		}
	}	

	sprintf(buf,"PORT0   %d  devices       PORT1   %d  devices\n", n0, n1);
	Device->SetText(buf);

}
