#ifndef __KApp_h__
#define __KApp_h__

#include <Application.h>

const char	kKEditDescription[]	= "KEdit v0.4.0 for BeOS R5 (or later)";

const char	kMySignature[]		= "application/x-vnd.karino-kedit";
const char	kTextPlain[]		= "text/plain";
const char	kTextHTML[]			= "text/html";
const char	kTextEmail[]		= "text/x-email";
const char	kSettingFile[]		= "KEditPrefs";
const char	kSettingDir[]		= "KRNSoftware";
const char	kBackgroundFolder[]	= "KEditBackground";


enum{
	K_REMOVE_WINDOW_POINTER = 'rmvm',
	K_REFRESH_WINDOW_MENU	= 'rfwm',
	K_GET_FRONTMOST_WINDOW	= 'gfmw',
	
	K_NEW			= 'knew',
	K_OPEN			= 'kopn',
	K_SWITCH_WINDOW	= 'swwd'
};


class	KPrefs;
class	KWindow;
class	KPrefsWindow;
class	KFindWindow;
class	KGoToLineWindow;


class KApp : public BApplication
{
public:
				KApp();
				~KApp();
	void		MessageReceived(BMessage* msg);
	void		ArgvReceived(int32 argc, char **argv);
	void		ReadyToRun();
	void		RefsReceived(BMessage* msg);
	void		AboutRequested();
	BHandler*	ResolveSpecifier(BMessage* msg, int32 index
									, BMessage* specifier, int32 form
									, const char* property);
	status_t	GetSupportedSuites(BMessage* msg);
	
	KPrefs*		GetPrefs(){ return fPrefs; }
	BList		GetWindowList() const { return fWindowList; }
	
	bool		IsTextFile(BEntry* entry);

private:
	KWindow*	MakeNewWindow(BEntry* entry = NULL);
	void		MakeFindWindow();
	//void		RefreshWindowMenu();
	void		ShowPrefsWindow();
	
	BList			fWindowList;
	BFilePanel*		fOpenPanel;
	KPrefs*			fPrefs;
	KPrefsWindow*	fPrefsWindow;
	KFindWindow*	fFindWindow;
	KGoToLineWindow* fGoToLineWindow;
};

#endif



