#include "KBottomView.h"

#include <View.h>
#include <TextView.h>

#include "KTextUtils.h"
#include "KWindow.h"

#include "KCharCodeView.h"
#include "KRetCodeView.h"
#include "KLineNumView.h"


KBottomView::KBottomView(BRect frame)
	:BView(frame, "bottomview", B_FOLLOW_LEFT | B_FOLLOW_BOTTOM
						, B_WILL_DRAW|B_PULSE_NEEDED)
{
	fDirty = false;

	BRect	rect = this->Bounds();
	rect.top += 2;
	rect.left += 15;
	rect.right = rect.left + 30;
	KCharCodeView*	charcodeview = new KCharCodeView(rect, "codeview");
	
	this->AddChild(charcodeview);
	
	rect.left += 40;
	rect.right = rect.left + 30;
	KRetCodeView*	retcodeview = new KRetCodeView(rect, "retview");
	
	this->AddChild(retcodeview);
	
	rect.left += 45;
	rect.right = rect.left + 70;
	
	KLineNumView*	linenumview = new KLineNumView(rect, "linenumview");
	
	this->AddChild(linenumview);
}


KBottomView::~KBottomView()
{
	
}


void
KBottomView::ConvertToStandard(char** text)
{
	((KCharCodeView*)FindView("codeview"))->ConvertToUTF8(text);
	((KRetCodeView*)FindView("retview"))->ConvertToLF(text);
}


void
KBottomView::ConvertFromStandard(char** text)
{
	((KCharCodeView*)FindView("codeview"))->ConvertFromUTF8(text);
	((KRetCodeView*)FindView("retview"))->ConvertFromLF(text);
}


void
KBottomView::AttachedToWindow()
{
	const rgb_color	viewcolor	= {220, 220, 220, 200};
	const rgb_color	highcolor	= {250, 250, 250};
	const rgb_color	lowcolor	= {150, 150, 150};
	
	this->SetViewColor(viewcolor);
	this->SetHighColor(highcolor);
	this->SetLowColor(lowcolor);
}

void
KBottomView::Draw(BRect rect)
{
	BRect	frame = this->Bounds();
	
	const rgb_color	aDarkColor = {150, 150, 150};
	const rgb_color	aLightColor = {250, 250, 250};
	
	this->BeginLineArray(10);
	this->SetPenSize(1.0);
	//upper dark gray line...
	this->AddLine(frame.LeftTop(), frame.RightTop(), aDarkColor);
	//left light gray line...
	this->AddLine(BPoint(frame.LeftTop().x, frame.LeftTop().y + 1.0)
					, frame.LeftBottom(), aLightColor);
	//upper light gray line...
	this->AddLine(BPoint(frame.LeftTop().x, frame.LeftTop().y + 1.0)
					, BPoint(frame.RightTop().x, frame.RightTop().y + 1.0)
					, aLightColor);
	this->EndLineArray();
	
	//Dirty point.
	if(fDirty){
		BRect	dRect(7, 7, 9, 9);
		dRect.OffsetBy(frame.LeftTop());
		this->StrokeRect(dRect, B_SOLID_LOW);
	}
	
	if(!((BTextView*)this->Window()->FindView("textview"))->IsEditable()){
		rgb_color	aCurrentHighColor = this->HighColor();
		rgb_color	aRectColor = {255, 0, 0};
		this->SetHighColor(aRectColor);
		BRect	aRect(7,7,9,9);
		aRect.OffsetBy(frame.LeftTop());
		this->StrokeRect(aRect, B_SOLID_HIGH);
		this->SetHighColor(aCurrentHighColor);
	}
	
	
}


void
KBottomView::Pulse()
{
	bool curDirty = ((KWindow*)this->Window())->GetDirty();
	if(curDirty != fDirty){
		fDirty = curDirty;
		this->Invalidate();
	}
	this->BView::Pulse();
}










