#include "KCharCodeView.h"

#include <PopUpMenu.h>
#include <MenuItem.h>
#include <Looper.h>

#include "KTextUtils.h"


KCharCodeView::KCharCodeView(BRect frame, const char* name)
		:BStringView(frame, name, "dummy")
{
	fCharCode = UTF8;
	this->SetFontSize(10);
	
	this->RedrawText();
}

KCharCodeView::~KCharCodeView()
{
	
}


void
KCharCodeView::MouseDown(BPoint where)
{
	BPopUpMenu* popup = new BPopUpMenu("popup");
	BMenuItem*	menuitem;
	
	popup->SetFont(be_plain_font);
	popup->SetFontSize(10);
	
	menuitem = new BMenuItem("UTF-8", new BMessage(UTF8));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fCharCode == UTF8 || fCharCode == ASCII)
		menuitem->SetMarked(true);
	
	menuitem = new BMenuItem("S-JIS", new BMessage(SJIS));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fCharCode == SJIS)
		menuitem->SetMarked(true);
	
	menuitem = new BMenuItem("JIS", new BMessage(NEW));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fCharCode == NEW)
		menuitem->SetMarked(true);
	
	menuitem = new BMenuItem("EUC", new BMessage(EUC));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fCharCode == EUC)
		menuitem->SetMarked(true);
	
	BPoint	point(this->Bounds().LeftTop());
	this->ConvertToScreen(&point);
	menuitem = NULL;
	menuitem = popup->Go(point);
	
	if(menuitem != NULL){
		BLooper*	looper;
		BHandler*	target = menuitem->Target(&looper);
		looper->PostMessage(menuitem->Message(), target);
	}
	
	delete popup;
}


void
KCharCodeView::MessageReceived(BMessage* msg)
{
	switch(msg->what){
		case UTF8:
		case SJIS:
		case NEW:
		case EUC:
			fCharCode = msg->what;
			this->RedrawText();
			break;
			
		default:
			this->BStringView::MessageReceived(msg);
	}
}


void
KCharCodeView::ConvertFromUTF8(char** text)
{
	KTextUtils	utils;
	
	if(fCharCode == NEW){
		utils.UTF82EUC(text);
		utils.EUC2JIS(text);
		
	}else if(fCharCode == EUC){
		utils.UTF82EUC(text);
		
	}else if(fCharCode == SJIS){
		utils.UTF82SJIS(text);
		
	}else if(fCharCode == UTF8 || fCharCode == ASCII){
		//Do nothing.
	}else{
		
	}
}


void
KCharCodeView::ConvertToUTF8(char** text)
{
	KTextUtils	utils;
	fCharCode = utils.DetectCodeType(*text);
	
	if(fCharCode == NEW){
		utils.JIS2EUC(text);
		utils.EUC2UTF8(text);
		
	}else if(fCharCode == EUC){
		utils.EUC2UTF8(text);
		
	}else if(fCharCode == SJIS){
		utils.SJIS2UTF8(text);
		
	}else if(fCharCode == UTF8 || fCharCode == ASCII){
		//Do nothing.
	}
	
	this->RedrawText();
}


void
KCharCodeView::RedrawText()
{	
	if(fCharCode == NEW){
		this->SetText("JIS");
		
	}else if(fCharCode == EUC){
		this->SetText("EUC");
		
	}else if(fCharCode == SJIS){
		this->SetText("S-JIS");
		
	}else if(fCharCode == UTF8){
		this->SetText("UTF-8");
	}
}








