#include "KFindView.h"

#include <CheckBox.h>
#include <Box.h>
#include <StringView.h>
#include <Path.h>
#include <Bitmap.h>
#include <TranslationUtils.h>
#include <FindDirectory.h>
#include <Button.h>

#include "KDirView.h"
#include "KTabTextView.h"
#include "KPrefs.h"
#include "KApp.h"

KFindView::KFindView(BRect frame)
	:BView(frame, "find", B_FOLLOW_ALL, B_WILL_DRAW)
		, fBackgroundBitmap(NULL)
{
	BRect	aViewRect = Bounds();
	KPrefs*	prefs = ((KApp*)be_app)->GetPrefs();
	
	BFont	aFont(be_plain_font);
	const char	*aFamily, *aStyle;
	float	aSize;
	
	prefs->Lock();
	prefs->GetData("font_family", &aFamily);
	prefs->GetData("font_style", &aStyle);
	prefs->GetData("font_size", &aSize);
	prefs->Unlock();
	
	aFont.SetFamilyAndStyle(aFamily, aStyle);
	aFont.SetSize(aSize);
	
	////////////////////
	// Add Buttons
	////////////////////
	
	//"Find" button (default)
	BButton*	aButton;
	BRect		aButtonFrame(0,0,65,25);//width=65,height=25
	BRect		aButtonFrame2;
	aButtonFrame.OffsetBy(aViewRect.Width() - 80, aViewRect.Height() - 40);
	
	BButton* aDefButton = new BButton(aButtonFrame, "ok_button", "Find"
					, new BMessage(K_OK_BUTTON_PRESSED));
	this->AddChild(aDefButton);
	aDefButton->MakeDefault(true);
	aDefButton->SetFont(be_bold_font, B_FONT_ALL);
	
	aButtonFrame2 = aButtonFrame;//for "Replace All" button
	
	//"Set" button
	aButtonFrame.OffsetBy(-80,0);
	aButton = new BButton(aButtonFrame,"set_button","Set (S)"
					, new BMessage(K_SET_BUTTON_PRESSED));
	this->AddChild(aButton);
	aButton->SetFont(be_bold_font, B_FONT_ALL);
	
	//"Cancel" button
	aButtonFrame.OffsetBy(-80,0);
	aButton = new BButton(aButtonFrame,"cancel_button","Cancel"
					, new BMessage(K_CANCEL_BUTTON_PRESSED));
	this->AddChild(aButton);
	aButton->SetFont(be_bold_font, B_FONT_ALL);
	
	//"Replace All" button
	aButtonFrame2.OffsetBy(0, -45);
	aButtonFrame2.left -= 30;
	aButton = new BButton(aButtonFrame2,"replace_all_button", "Replace All (R)"
					, new BMessage(K_REPLACE_ALL_PRESSED));
	this->AddChild(aButton);
	
	
	////////////////////
	// Add String View
	////////////////////
	
	BStringView*	aStringView;
	BRect			aStringFrame(0, 0, 50, 20);
	//BPoint			point(10, 40);//FontMenus' LeftTop point.
	
	aStringFrame.OffsetBy(10,10);
	aStringView = new BStringView(aStringFrame,"stringview"
					, "Find");
	this->AddChild(aStringView);
	aStringView->SetFont(be_bold_font, B_FONT_ALL);
	
	aStringFrame.OffsetBy(0, 40);
	aStringView = new BStringView(aStringFrame, "stringview"
					, "Replace");
	this->AddChild(aStringView);
	aStringView->SetFont(be_bold_font, B_FONT_ALL);
	
	////////////////////
	// Add Checkboxes
	////////////////////
	
	BCheckBox*	aCheckBox;
	BRect	aCheckBoxFrame(0, 0, 140, 15);
	aCheckBoxFrame.OffsetBy(20, 90);
	/*
	aCheckBox = new BCheckBox(aCheckBoxFrame, "use_regexp", "Use RegExp ( E )"
					, NULL);
	this->AddChild(aCheckBox);
	aCheckBox->SetFont(be_plain_font, B_FONT_ALL);
	aCheckBox->SetValue(false);
	aCheckBox->SetEnabled(false);*/
	
	aCheckBoxFrame.OffsetBy(0, 17);
	aCheckBox = new BCheckBox(aCheckBoxFrame, "ignore_case", "Ignore Case ( I )"
					, NULL);
	this->AddChild(aCheckBox);
	aCheckBox->SetFont(be_plain_font, B_FONT_ALL);
	aCheckBox->SetValue(true);
	/*
	aCheckBoxFrame.OffsetBy(0, 17);
	aCheckBox = new BCheckBox(aCheckBoxFrame, "multi_file_search", "Multi File Search ( M )"
					, NULL);
	this->AddChild(aCheckBox);
	aCheckBox->SetFont(be_plain_font, B_FONT_ALL);
	aCheckBox->SetValue(false);*/
	
	////////////////////
	// Add dir name view
	////////////////////
	
	/*
	BRect	aDirFrame(0, 0, 120, 18);
	aDirFrame.OffsetBy(aCheckBoxFrame.LeftTop().x + 20,
						aCheckBoxFrame.LeftTop().y + 20);
	
	BBox*	aDirBox = new BBox(aDirFrame, "dirbox");
	this->AddChild(aDirBox);
	
	aDirFrame.OffsetTo(B_ORIGIN);
	aDirFrame.top++;
	aDirFrame.left += 3;
	aDirFrame.bottom -= 2;
	aDirFrame.right -= 2;
	
	KDirView*	aDirStringView = new KDirView(aDirFrame, "dir_string", "<none>");
	aDirBox->AddChild(aDirStringView);
	//aDirStringView->SetAlignment(B_ALIGN_CENTER);
	aDirStringView->SetFont(be_plain_font, B_FONT_ALL);*/
	
	
	////////////////////
	// Add TextView
	////////////////////

	KTabTextView*	aFindView;
	KTabTextView*	aReplaceView;
	
	BBox*	aBox;
	BRect	aBoxFrame(0, 0, 180, 35);
	BRect	aTextFrame;
	
	aTextFrame = aBoxFrame;
	aTextFrame.OffsetTo(B_ORIGIN);
	aBoxFrame.OffsetBy(80,10);
	
	aTextFrame.top++;
	aTextFrame.left++;
	aTextFrame.bottom -= 2;
	aTextFrame.right -= 2;
	
	aBox = new BBox(aBoxFrame,"bbox");
	
	aFindView = new KTabTextView(aTextFrame, "find_view", aTextFrame
								, B_FOLLOW_ALL, B_WILL_DRAW|B_PULSE_NEEDED);
	aBox->AddChild(aFindView);
	aFindView->SetFontAndColor(&aFont);
	this->AddChild(aBox);
	
	aBoxFrame.OffsetBy(0, 40);
	
	aBox = new BBox(aBoxFrame,"bbox");
	
	aReplaceView = new KTabTextView(aTextFrame, "replace_view", aTextFrame
								, B_FOLLOW_ALL, B_WILL_DRAW|B_PULSE_NEEDED);
	aBox->AddChild(aReplaceView);
	aReplaceView->SetFontAndColor(&aFont);
	this->AddChild(aBox);
	
	aReplaceView->SetNextView(aFindView);
	aReplaceView->SetPrevView(aFindView);
	aFindView->SetNextView(aReplaceView);
	aFindView->SetPrevView(aReplaceView);
}

KFindView::~KFindView()
{
	delete	fBackgroundBitmap;
}

void
KFindView::AttachedToWindow()
{
	const rgb_color	color = ::ui_color(B_PANEL_BACKGROUND_COLOR);//{240,240,240};
	this->SetViewColor(color);
	
	BBitmap*	aBitmap;
	BPath		aPath;
	::find_directory(B_USER_SETTINGS_DIRECTORY, &aPath, true);
	aPath.Append(kSettingDir);
	aPath.Append(kBackgroundFolder);
	aPath.Append(kBackgroundImageName);
	
	aBitmap = BTranslationUtils::GetBitmap(aPath.Path(), NULL);
	
	if(aBitmap != NULL){
		if(aBitmap->ColorSpace() == B_RGB32){//only for 32-bit color graphics.
			int32	aLength = aBitmap->BitsLength();
			uchar*	aData = (uchar*)aBitmap->Bits();
			for(int32 i = 0; i < aLength; i++){
				*(aData + i) += (255 - *(aData + i))/3;
			}
		}
		
		this->SetViewBitmap(aBitmap);
		
		fBackgroundBitmap = aBitmap;
		
		int32	aCount = this->CountChildren();
		BView*	aView = NULL;
		for(int32 i = 0; i < aCount; i++){
			if((aView = dynamic_cast<BView*>(this->ChildAt(i))) != NULL){
				//BPoint	where(aView->Frame().LeftTop());
				BRect	aViewFrame(aView->Frame());
				BRect	aDestFrame(aViewFrame);
				aDestFrame.OffsetTo(B_ORIGIN);
				
				aView->SetViewBitmap(aBitmap, aViewFrame, aDestFrame);
			}
		}
	}else{
		
	}
}









