#include "KTabTextView.h"

#include <Window.h>
#include <Message.h>

#include "KFindView.h"

KTabTextView::KTabTextView(BRect frame, const char *name, BRect textRect
					, uint32 resizeMask, uint32 frags)
	:BTextView(frame, name, textRect, resizeMask, frags)
{
	fNextView = NULL;
	fPrevView = NULL;

}

void
KTabTextView::KeyDown(const char *bytes, int32 numBytes)
{
	BMessage*	msg = this->Window()->CurrentMessage();
	int32		aRawChar;
	uint32		aModifiers;
	msg->FindInt32("raw_char", &aRawChar);
	msg->FindInt32("modifiers", (int32*)&aModifiers);
	
	if(aRawChar == B_TAB){
		if((aModifiers & B_SHIFT_KEY) == 0){
			if(fNextView != NULL){
				fNextView->MakeFocus(true);
				((BTextView*)fNextView)->SelectAll();
			}
		}else{
			if(fPrevView != NULL){
				fPrevView->MakeFocus(true);
				((BTextView*)fNextView)->SelectAll();
			}
		}
	}else if(aRawChar == B_ESCAPE){
		this->Window()->PostMessage(new BMessage(K_CANCEL_BUTTON_PRESSED));
	}else{
		this->BTextView::KeyDown(bytes, numBytes);
	}
}



void
KTabTextView::Pulse()
{
	this->BTextView::Pulse();
}












