#include "KMailUtils.h"

#include <E-mail.h>
#include <Directory.h>
#include <File.h>
#include <Alert.h>
#include <Beep.h>
#include <NodeInfo.h>
#include <fs_attr.h>
#include <time.h>
#include <stdio.h>
#include <string.h>

#include "KApp.h"

#include "KString.h"
#include "KTextUtils.h"
#include "KSearch.h"

KMailUtils::KMailUtils()
{
	
}


status_t
KMailUtils::Send(const char* text, bool send_now)
{
	KTextUtils	aUtils;
	
	const KString	kTo		= "to:";
	const KString	kSubj	= "subj:";
	const KString	kCC		= "cc:";
	const KString	kBCC	= "bcc:";
	
	const char		kMimeVersion[] = "1.0";
	
	KString		aWholeString = text;
	
	KString		aToString, aSubjString, aCCString, aBCCString;
	KString		aParagraph;

	int32		aParagNum = aWholeString.CountParagraphs();
	int32		aCurLine = 0;
	
	for(; aCurLine < aParagNum - 1; aCurLine++){
		aParagraph = aWholeString.Paragraph(aCurLine);
		if(aParagraph.StartsWith(kSubj)){
			aSubjString.Copy(aParagraph, kSubj.Length());
		}else if(aParagraph.StartsWith(kTo)){
			aToString.Copy(aParagraph, kTo.Length());
		}else if(aParagraph.StartsWith(kCC)){
			aCCString.Copy(aParagraph, kCC.Length());
		}else if(aParagraph.StartsWith(kBCC)){
			aBCCString.Copy(aParagraph, kBCC.Length());
		}else{
			break;
		}
	}
	
	//Subject and To field must exist...
	if(aSubjString.IsEmpty() || aToString.IsEmpty()){ ::beep(); return B_ERROR; }
	
	//Alert for sending email.
	BAlert*	aAlert = new BAlert(B_EMPTY_STRING
								, "Are you sure to send this text as e-mail?"
								, "Cancel"
								, "OK");
	aAlert->SetShortcut(0, B_ESCAPE);
	
	int32	aResult = aAlert->Go();
	if(aResult == 0){ return B_ERROR; }
	
	int32	aLen = ::strlen(text);
	int32	aPosition = 0;
	int32	aLFNum = 0;
	
	for(; aPosition < aLen; aPosition++){
		if(*(text + aPosition) == kLF){ aLFNum++; }
		if(aLFNum == aCurLine){ break; }
	}
	
	//MIME encoding...
	char*	aEncodedSubj = new char[aSubjString.Length() + 1];
	::strcpy(aEncodedSubj, aSubjString.Text());
	this->Convert2MIME(&aEncodedSubj);
	
	//Construct Email Message...
	
	mail_pop_account	aAccount;
	if(get_pop_account(&aAccount, 0) != B_NO_ERROR){ beep(); return B_ERROR; }
	
	KString	aFromString;
	aFromString << "\"" << aAccount.real_name << "\" <" << aAccount.reply_to << ">";
	
	KString	aReplyToString = aAccount.reply_to;
	KString	aBodyString(aWholeString.Text() + aPosition + 1);
	
	time_t	aCurrentTime;
	::time(&aCurrentTime);
	
	KString	aFileNameString;
	aFileNameString << "<" << aToString << ">:" << aCurrentTime;
	
	KString	aEmailString;
	aEmailString << "To: " << aToString;
	aEmailString << "\nFrom: " << aFromString;
	aEmailString << "\nSubject: " << aEncodedSubj;
	aEmailString << "\nDate: " << this->GetCurrentDateString().Text();
	aEmailString << "\nX-Mailer: " << kKEditDescription;
	aEmailString << "\nMIME-Version: " << kMimeVersion;
	aEmailString << "\nContent-Type: text/plain; charset=\"ISO-2022-JP\"";
	aEmailString << "\nReply-To: " << aReplyToString;
	aEmailString << "\n\n";
	
	//Make Email Text...
	KString	aNewWholeString = aEmailString;
	aNewWholeString << aBodyString << "\n";
	char*	aNewWholeText = new char[aNewWholeString.Length() + 1];
	::strcpy(aNewWholeText, aNewWholeString.Text());

	aUtils.UTF82EUC(&aNewWholeText);
	aUtils.EUC2JIS(&aNewWholeText);
	aUtils.ConvertReturnCode(&aNewWholeText, K_CRLF);
	
	//culculate lengths of the body and header...
	char*	aBodyText = new char[aBodyString.Length() + 1];
	char*	aEmailText = new char[aEmailString.Length() + 1];
	::strcpy(aBodyText, aBodyString.Text());
	::strcpy(aEmailText, aEmailString.Text());
	
	this->Convert2CRLF_JIS(&aEmailText);
	this->Convert2CRLF_JIS(&aBodyText);
	
	int32	aHeaderLen = ::strlen(aEmailText);
	int32	aContentLen = ::strlen(aBodyText);
	
	delete[]	aBodyText;
	delete[]	aEmailText;
	
	//set flags...
	int32	aFlags = B_MAIL_PENDING | B_MAIL_SAVE;
	
	//recipient string...
	KString	aRecipients = aToString;
	if(aRecipients.Contains("<")){//Remove useless characters...
		KString	aNewRecipients;
		aRecipients.SetTextItemDelimiter("<");
		aNewRecipients = aRecipients.TextItem(1);
		aNewRecipients.SetTextItemDelimiter(">");
		aRecipients = aNewRecipients.TextItem(0);
	}
	
	aRecipients.Prepend("<");
	if(!aCCString.IsEmpty()){ aRecipients << "," << aCCString; }
	if(!aBCCString.IsEmpty()){ aRecipients << "," << aBCCString; }
	aRecipients << ">";
	aRecipients.ReplaceAll(" ", "");
	aRecipients.ReplaceAll(",", ">,<");
	
	//Make New Message File...
	BDirectory	aDir("/boot/home");
	BFile		aFile;
	BEntry		aEntry;
	if(aDir.InitCheck() != B_NO_ERROR){ return B_ERROR; }
	if(aDir.FindEntry("mail", &aEntry) != B_NO_ERROR){ aDir.CreateDirectory("mail", &aDir); }
	else{ aDir.SetTo(&aEntry); }

	if(aDir.InitCheck() != B_NO_ERROR){ return B_ERROR; }
	
	if(aDir.FindEntry("out", &aEntry) != B_NO_ERROR){ aDir.CreateDirectory("out", &aDir); }
	else{ aDir.SetTo(&aEntry); }

	if(aDir.InitCheck() != B_NO_ERROR){ return B_ERROR; }
	if(aDir.CreateFile(aFileNameString.Text(), &aFile) != B_NO_ERROR){ return B_ERROR; }
	
	BNodeInfo	aInfo(&aFile);
	aInfo.SetType(B_MAIL_TYPE);
	
	//Write Data...
	aFile.Lock();
	aFile.Write(aNewWholeText, ::strlen(aNewWholeText));
	aFile.Unlock();
	
	//Write Attributes...
	aFile.WriteAttr(B_MAIL_ATTR_TO, B_STRING_TYPE, 0, aToString.Text(), aToString.Length() + 1);
	aFile.WriteAttr(B_MAIL_ATTR_FROM, B_STRING_TYPE, 0, aFromString.Text(), aFromString.Length() + 1);
	aFile.WriteAttr(B_MAIL_ATTR_SUBJECT, B_STRING_TYPE, 0, aSubjString.Text(), aSubjString.Length() + 1);
	aFile.WriteAttr(B_MAIL_ATTR_REPLY, B_STRING_TYPE, 0, aReplyToString.Text(), aReplyToString.Length() + 1);
	aFile.WriteAttr(B_MAIL_ATTR_RECIPIENTS, B_STRING_TYPE, 0, aRecipients.Text(), aRecipients.Length() + 1);
	aFile.WriteAttr(B_MAIL_ATTR_WHEN, B_INT32_TYPE, 0, &aCurrentTime, sizeof(time_t));
	aFile.WriteAttr(B_MAIL_ATTR_STATUS, B_STRING_TYPE, 0, "Pending\0", 8);
	aFile.WriteAttr(B_MAIL_ATTR_HEADER, B_INT32_TYPE, 0, &aHeaderLen, sizeof(int32));
	aFile.WriteAttr(B_MAIL_ATTR_CONTENT, B_INT32_TYPE, 0, &aContentLen, sizeof(int32));
	aFile.WriteAttr(B_MAIL_ATTR_MIME, B_STRING_TYPE, 0, kMimeVersion, ::strlen(kMimeVersion) + 1);
	aFile.WriteAttr(B_MAIL_ATTR_FLAGS, B_INT32_TYPE, 0, &aFlags, sizeof(int32));
	
	if(!aCCString.IsEmpty()){
		aFile.WriteAttr(B_MAIL_ATTR_CC, B_STRING_TYPE, 0, aCCString.Text(), aCCString.Length() + 1);
	}
	
	
	//Send and Check Mails...
	if(send_now){
		::send_queued_mail();
		::check_for_mail();
	}
	
	delete[]	aNewWholeText;
	delete[]	aEncodedSubj;
	
	return B_NO_ERROR;
}


void
KMailUtils::Reply(const BEntry* entry)
{
	const char	kQuoteMark[] = "> ";
	
	char	*aSubject, *aReplyTo, *aBody;
	int32	aHeaderLen, aBodyLen;
	aSubject = aReplyTo = aBody = NULL;
	aHeaderLen = aBodyLen = 0;
	
	
	BFile	aFile(entry, O_RDONLY);
	aFile.Lock();
	
	attr_info	aInfo;
	
	//SUBJECT
	if(aFile.GetAttrInfo(B_MAIL_ATTR_SUBJECT, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aSubject = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_SUBJECT, B_STRING_TYPE, 0, aSubject, aInfo.size);
	}else{
		aSubject = new char[1];
		*aSubject = '\0';
	}
	//REPLY-TO
	if(aFile.GetAttrInfo(B_MAIL_ATTR_REPLY, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aReplyTo = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_REPLY, B_STRING_TYPE, 0, aReplyTo, aInfo.size);
	}else if(aFile.GetAttrInfo(B_MAIL_ATTR_FROM, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aReplyTo = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_FROM, B_STRING_TYPE, 0, aReplyTo, aInfo.size);
	}else{
		aReplyTo = new char[1];
		*aReplyTo = '\0';
	}
	//HEADER LENGTH
	if(aFile.GetAttrInfo(B_MAIL_ATTR_HEADER, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aFile.ReadAttr(B_MAIL_ATTR_HEADER, B_INT32_TYPE, 0, &aHeaderLen, aInfo.size);
	}
	//CONTENT LENGTH
	if(aFile.GetAttrInfo(B_MAIL_ATTR_CONTENT, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aFile.ReadAttr(B_MAIL_ATTR_CONTENT, B_INT32_TYPE, 0, &aBodyLen, aInfo.size);
	}
	
	//BODY
	off_t	aFileSize;
	aFile.GetSize(&aFileSize);
	
	aBody = new char[aFileSize + 1];
	aFile.Read(aBody, aFileSize);
	*(aBody + aFileSize) = '\0';
	
	KTextUtils	utils;
	
	//convert : aHeaderLen
	char*	aHeaderBuffer = new char[aHeaderLen + 1];
	*aHeaderBuffer = '\0';
	::strncat(aHeaderBuffer, aBody, aHeaderLen);
	utils.ConvertReturnsToLF(aHeaderBuffer);
	utils.ConvertCharCodeToUTF8(&aHeaderBuffer);
	aHeaderLen = ::strlen(aHeaderBuffer);
	delete[]	aHeaderBuffer;
	
	//convert : aBody
	utils.ConvertReturnsToLF(aBody);
	utils.ConvertCharCodeToUTF8(&aBody);
	
	for(int32	i = 0;; i++){
		*(aBody + i) = *(aBody + i + aHeaderLen);
		if(*(aBody + i) == '\0'){ break; }
	}
	
	
	KSearch		aSearch(aBody, false);
	char*		aNewBody;
	KString		aQuoteString;
	int32		aCount;
	
	aQuoteString << "\n" << kQuoteMark;
	
	//add quotes to line heads.
	aSearch.ReplaceAll("\n", aQuoteString.Text(), &aNewBody, &aCount);
	
	delete[]	aBody;
	aBody = aNewBody;
	
	//convert : aBodyLen
	aBodyLen = ::strlen(aBody);
	
	//add "Re: " to the title.
	KString	aSubjString = aSubject;
	if(!aSubjString.StartsWith("Re: ")){
		aSubjString.Prepend("Re: ");
	}
	
	char*	aNewText = new char[aBodyLen + aSubjString.Length() + ::strlen(aReplyTo) + 256];
	
	::sprintf(aNewText, "subj:%s\nto:%s\n\n%s%s", aSubjString.Text(), aReplyTo, kQuoteMark, aBody);
	
	aFile.Unlock();
	
	BMessage*	aMessage = new BMessage(K_NEW);
	aMessage->AddString("title", aReplyTo);
	aMessage->AddString("content", aNewText);
	be_app->PostMessage(aMessage);
	
	delete[]	aNewText;
	
	delete[]	aSubject;
	delete[]	aReplyTo;
	delete[]	aBody;
	
}


void
KMailUtils::Forward(const BEntry* entry)
{
	char	*aSubject, *aBody;
	int32	aHeaderLen, aBodyLen;
	aSubject = aBody = NULL;
	aHeaderLen = aBodyLen = 0;
	
	
	BFile	aFile(entry, O_RDONLY);
	aFile.Lock();
	
	attr_info	aInfo;
	
	//SUBJECT
	if(aFile.GetAttrInfo(B_MAIL_ATTR_SUBJECT, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aSubject = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_SUBJECT, B_STRING_TYPE, 0, aSubject, aInfo.size);
	}else{
		aSubject = new char[1];
		*aSubject = '\0';
	}
	//HEADER LENGTH
	if(aFile.GetAttrInfo(B_MAIL_ATTR_HEADER, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aFile.ReadAttr(B_MAIL_ATTR_HEADER, B_INT32_TYPE, 0, &aHeaderLen, aInfo.size);
	}
	//CONTENT LENGTH
	if(aFile.GetAttrInfo(B_MAIL_ATTR_CONTENT, &aInfo) == B_NO_ERROR
			&& aInfo.size > 1){
		aFile.ReadAttr(B_MAIL_ATTR_CONTENT, B_INT32_TYPE, 0, &aBodyLen, aInfo.size);
	}
	
	//BODY
	off_t	aFileSize;
	aFile.GetSize(&aFileSize);
	
	aBody = new char[aFileSize + 1];
	aFile.Read(aBody, aFileSize);
	*(aBody + aFileSize) = '\0';
	
	KTextUtils	utils;
	
	//convert : aHeaderLen
	char*	aHeaderBuffer = new char[aHeaderLen + 1];
	*aHeaderBuffer = '\0';
	::strncat(aHeaderBuffer, aBody, aHeaderLen);
	utils.ConvertReturnsToLF(aHeaderBuffer);
	utils.ConvertCharCodeToUTF8(&aHeaderBuffer);
	aHeaderLen = ::strlen(aHeaderBuffer);
	delete[]	aHeaderBuffer;
	
	//convert : aBody
	utils.ConvertReturnsToLF(aBody);
	utils.ConvertCharCodeToUTF8(&aBody);
	
	for(int32	i = 0;; i++){
		*(aBody + i) = *(aBody + i + aHeaderLen);
		if(*(aBody + i) == '\0'){ break; }
	}

	
	//convert : aBodyLen
	aBodyLen = ::strlen(aBody);
	
	//add "Fwd: " to the title.
	char*	aNewSubject = new char[::strlen(aSubject) + 256];
	::sprintf(aNewSubject, "Fwd: %s", aSubject);
	delete[]	aSubject;
	aSubject = aNewSubject;
	
	char*	aNewText = new char[aBodyLen + ::strlen(aSubject) + 256];
	
	::sprintf(aNewText, "subj:%s\nto:\n%s", aSubject, aBody);
	
	aFile.Unlock();
	
	BMessage*	aMessage = new BMessage(K_NEW);
	aMessage->AddString("title", aSubject);
	aMessage->AddString("content", aNewText);
	be_app->PostMessage(aMessage);
	
	delete[]	aNewText;
	
	delete[]	aSubject;
	delete[]	aBody;
}


status_t
KMailUtils::LoadMail(const BEntry* entry, char** text, char** win_title)
{	
	BFile		aFile(entry, B_READ_ONLY);
	attr_info	aInfo;
	char*		aBuffer;
	
	aFile.Lock();
	
	
	//From...
	if(aFile.GetAttrInfo(B_MAIL_ATTR_FROM, &aInfo) != B_NO_ERROR
			|| aInfo.size <= 0){ return B_ERROR; }
	aBuffer = new char[aInfo.size];
	aFile.ReadAttr(B_MAIL_ATTR_FROM, B_STRING_TYPE, 0, aBuffer, aInfo.size);
	KString	aFrom = aBuffer;
	delete[]	aBuffer;
	
	//To...
	if(aFile.GetAttrInfo(B_MAIL_ATTR_TO, &aInfo) != B_NO_ERROR
			|| aInfo.size <= 0){ return B_ERROR; }
	aBuffer = new char[aInfo.size];
	aFile.ReadAttr(B_MAIL_ATTR_TO, B_STRING_TYPE, 0, aBuffer, aInfo.size);
	KString	aTo = aBuffer;
	delete[]	aBuffer;
	
	//Subject...
	if(aFile.GetAttrInfo(B_MAIL_ATTR_SUBJECT, &aInfo) != B_NO_ERROR
			|| aInfo.size <= 0){ return B_ERROR; }
	aBuffer = new char[aInfo.size];
	aFile.ReadAttr(B_MAIL_ATTR_SUBJECT, B_STRING_TYPE, 0, aBuffer, aInfo.size);
	KString	aSubject = aBuffer;
	delete[]	aBuffer;
	
	//When...
	time_t	aWhen;
	if(aFile.GetAttrInfo(B_MAIL_ATTR_WHEN, &aInfo) != B_NO_ERROR
			|| aInfo.size <= 0){ return B_ERROR; }
	aFile.ReadAttr(B_MAIL_ATTR_WHEN, B_INT32_TYPE, 0, &aWhen, aInfo.size);
	
	tm*		aTime = localtime(&aWhen);
	char	aTimeStr[256];
	::sprintf(aTimeStr, "%d/%d/%d %d:%d:%d (%s)"
				, aTime->tm_year + 1900
				, aTime->tm_mon + 1
				, aTime->tm_mday
				, aTime->tm_hour, aTime->tm_min, aTime->tm_sec
				, aTime->tm_zone);
	
	//recipients...
	if(aFile.GetAttrInfo(B_MAIL_ATTR_RECIPIENTS, &aInfo) == B_NO_ERROR
			&& aInfo.size > 0){
		aBuffer = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_RECIPIENTS, B_STRING_TYPE, 0, aBuffer, aInfo.size);
		KString		aBufString = aBuffer;
		//aBufString.PrintToStream();
		delete[]	aBuffer;
	}
	
	//CC
	KString	aCC;
	if(aFile.GetAttrInfo(B_MAIL_ATTR_CC, &aInfo) == B_NO_ERROR
			&& aInfo.size > 0){
		aBuffer = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_CC, B_STRING_TYPE, 0, aBuffer, aInfo.size);
		aCC = aBuffer;
		delete[]	aBuffer;
		aCC.ReplaceAll(" ", "");
		aCC.ReplaceAll(",", "\ncc  : ");
		aCC.Prepend("\ncc  : ");
	}
	
	//mime
	if(aFile.GetAttrInfo(B_MAIL_ATTR_MIME, &aInfo) == B_NO_ERROR
			&& aInfo.size > 0){
		aBuffer = new char[aInfo.size];
		aFile.ReadAttr(B_MAIL_ATTR_MIME, B_STRING_TYPE, 0, aBuffer, aInfo.size);
		KString	aString = aBuffer;
		//aString.PrintToStream();
	}
	
	/* begin test */
	{
		
		
	}
	/* end test */
	
	//HeaderLen...
	int32	aHeaderLen;
	if(aFile.GetAttrInfo(B_MAIL_ATTR_HEADER, &aInfo) != B_NO_ERROR
			|| aInfo.size <= 0){ return B_ERROR; }
	aFile.ReadAttr(B_MAIL_ATTR_HEADER, B_INT32_TYPE, 0, &aHeaderLen, aInfo.size);
	
	char*	aHeaderStr = new char[aHeaderLen + 1];
	aFile.ReadAt(0, aHeaderStr, aHeaderLen);
	*(aHeaderStr + aHeaderLen) = '\0';
	
	aFile.Unlock();
	
	KTextUtils	aUtils;
	aUtils.ConvertReturnsToLF(aHeaderStr);
	aUtils.ConvertCharCodeToUTF8(&aHeaderStr);
	aHeaderLen = ::strlen(aHeaderStr);
	delete[]	aHeaderStr;
	KString		aBody(*text + aHeaderLen);
	KString		aWholeString("");
	aWholeString << "subj: " << aSubject
				<< "\nfrom: " << aFrom
				<< "\nto  : " << aTo
				<< aCC
				<< "\ndate: " << aTimeStr
				<< "\n\n" << aBody;
	
	KString		aWindowTitle;
	aWindowTitle << "from " << aFrom << " : " << aSubject;
	
	
	char*	aText = new char[aWholeString.Length() + 1];
	::strcpy(aText, aWholeString.Text());
	delete[]	*text;
	*text = aText;
	
	char*	aTitle = new char[aWindowTitle.Length() + 1];
	::strcpy(aTitle, aWindowTitle.Text());
	*win_title = aTitle;

	return B_NO_ERROR;
}





void
KMailUtils::Convert2CRLF_JIS(char** text)
{
	KTextUtils	aUtils;
	
	char*	aBuffer = new char[::strlen(*text) + 1];
	::strcpy(aBuffer, *text);
	aUtils.ConvertReturnCode(&aBuffer, K_CRLF);
	aUtils.UTF82EUC(&aBuffer);
	aUtils.EUC2JIS(&aBuffer);
	delete[]	*text;
	*text = aBuffer;
}


KString
KMailUtils::GetCurrentDateString()
{
	/*format = wkday, day month year hh:mm:ss zone*/
	
	char*	kWeekday[]	=	{ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
	char*	kMonth[]	=	{ "Jan", "Feb", "Mar", "Apr", "May", "Jun"
								, "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
	time_t	aCurrentTime;
	tm*		aTM;
	
	::time(&aCurrentTime);
	aTM = ::localtime(&aCurrentTime);
	
	char*	aBuffer = new char[256];
	::sprintf(aBuffer, "%s, %d %s %d %s:%s:%s (%s)"
				, kWeekday[aTM->tm_wday]
				, aTM->tm_mday
				, kMonth[aTM->tm_mon]
				, aTM->tm_year + 1900
				, this->conv_two_dec(aTM->tm_hour).Text()
				, this->conv_two_dec(aTM->tm_min).Text()
				, this->conv_two_dec(aTM->tm_sec).Text()
				, aTM->tm_zone);
	KString	aString = aBuffer;
	delete[]	aBuffer;
	
	return aString;
}


KString
KMailUtils::conv_two_dec(int32 num)
{
	KString	aString;
	aString << num;
	if(aString.Length() < 2){ aString.Prepend("0"); }
	return aString;
}


void
KMailUtils::Convert2MIME(char** text)
{
	char*	aEncodedSubj = new char[::strlen(*text) + 1];
	::strcpy(aEncodedSubj, *text);
	
	KTextUtils	aUtils;
	if(aUtils.CountChars(aEncodedSubj) != (int32)::strlen(aEncodedSubj)){
		aUtils.UTF82EUC(&aEncodedSubj);
		aUtils.EUC2JIS(&aEncodedSubj);
		aUtils.JIS2MIME(&aEncodedSubj);
	}
	
	delete[]	*text;
	*text = aEncodedSubj;
}














