#ifndef __KMenuBar_h__
#define __KMenuBar_h__

#include <MenuBar.h>

const char		kFileMenuName[]			= "File";
const char		kFontMenuName[]			= "Font";
const char		kOptionMenuName[]		= "Option";
const char		kTextMenuName[]			= "Text";
const char		kWindowMenuName[]		= "Window";
const char		kAddOnMenuName[]		= "Add-ons";

const char		kSaveMenuItemName[]		= "Save";

const char		kSizeMenuItemName[]			= "Size";
const char		kTabWidthMenuItemName[]		= "Tab Width";
const char		kWordWrapMenuItemName[]		= "Word Wrap";
const char		kAutoIndentMenuItemName[]	= "Auto Indent";
const char		kMemorizeMenuItemName[]		= "Memorize Window Status";
const char		kHTMLMenuItemName[]			= "HTML";
const char		kEmailMenuItemName[]		= "E-mail";
const char		kUseHTMLMenuItemName[]		= "Use HTML Syntax";

const char		kOpenUserTagFileItemName[]	= "Open UserTag file";

const char		kAddOnDirNameInAppDir[]		= "add-ons";
const char		kAddOnDirNameInConfigDir[]	= "KEdit";

const char		kUserTagFileName[] 			= "UserTags";

const int8		kFontSizeSet[]	= {9,10,12,14,18,24,36,48,72};

enum{
	K_SAVE		= 'ksve',
	K_SAVE_AS	= 'ksva',
	
	K_OPEN_PREV_ENTRY	= 'oppr',
	K_OPEN_NEXT_ENTRY	= 'opnx',
	
	K_CLOSE		= 'clos',
	
	K_INFORMATION	= 'kinf',
	
	K_UNDO		= 'undo',
	
	K_FONT		= 'font',
	K_STYLE		= 'styl',
	K_SIZE		= 'size',
	K_TAB_WIDTH	= 'tbwd',
	
	K_FIND						= 'find',
	K_FIND_AGAIN				= 'fnda',
	K_REPLACE					= 'rplc',
	K_REPLACE_AND_FIND_AGAIN	= 'rpfa',
	
	K_SHOW_GO_TO_LINE_WINDOW	= 'kgtl',
	
	K_TEXT_SHIFT_RIGHT			= 'ktsr',
	K_TEXT_SHIFT_LEFT			= 'ktsl',
	K_TEXT_SHIFT_PREFIX_RIGHT	= 'tspr',
	K_TEXT_SHIFT_PREFIX_LEFT	= 'tspl',
	K_TEXT_WRAP_LINE			= 'ktwl',
	K_TEXT_REMOVE_RETURNS		= 'ktrr',
	
	K_WORD_WRAP			= 'wwrp',
	K_AUTO_INDENT		= 'audi',
	K_MEMORIZE_WINDOW	= 'mrwd',
	K_USE_HTML_SYNTAX	= 'synt',
	K_REPLY_TO_SENDER	= 'rpls',
	K_MAIL_FORWORD		= 'frwd',
	K_SEND_EMAIL_LATER	= 'sndl',
	K_SEND_EMAIL_NOW	= 'sndn',
	K_SHOW_HEADERS		= 'shds',
	
	K_SHOW_PREFS_WINDOW	= 'spwd',
	
	
	K_OPEN_WITH_BROWSER	= 'opbr',
	K_OPEN_WITH_BEMAIL	= 'opbm',
	K_EXEC_ADD_ON		= 'radn',
	
	K_HTML_TAG			= 'htag',
	K_EMAIL_ADDRESS		= 'emal',
	K_URL_STRING		= 'urls'
};


class KMenuBar : public BMenuBar
{
	public:
				KMenuBar(BRect frame, const char* title);
				
		void	AttachedToWindow();
		
		void	UpdateMenus();
		void	ConstructTagMenu(BMenu* menu);
		
		status_t	MakeAddOnMenu(BMenu* menu);

	private:
		void		SetUpMenus();
		BMenuItem*	MakeTagMenuItem(const char* name
									, const char* pre, const char* post
									, char shortcut = 0
									, uint32 modifiers = 0);
									
		bool		MakeUserTagMenu(BMenu* menu);
		void		MakeDefTagMenu(BMenu* menu);
		void		AddAddOnMenu(BMenu* menu, BDirectory dir);
		
		status_t	GetUserTagFileEntry(BEntry* entry);
									
		BList		fMessageList;
};

#endif








