#include "KRetCodeView.h"

#include <PopUpMenu.h>
#include <MenuItem.h>
#include <Looper.h>

#include "KTextUtils.h"


KRetCodeView::KRetCodeView(BRect frame, const char* name)
		:BStringView(frame, name, "dummy")
{
	fRetCode = K_LF;
	this->SetFontSize(10);
	
	this->RedrawText();
}

KRetCodeView::~KRetCodeView()
{
	
}


void
KRetCodeView::MouseDown(BPoint where)
{
	BPopUpMenu* popup = new BPopUpMenu("popup");
	BMenuItem*	menuitem;
	
	popup->SetFont(be_plain_font);
	popup->SetFontSize(10);
	
	menuitem = new BMenuItem("LF", new BMessage(K_LF));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fRetCode == K_LF)
		menuitem->SetMarked(true);
	
	menuitem = new BMenuItem("CR", new BMessage(K_CR));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fRetCode == K_CR)
		menuitem->SetMarked(true);
	
	menuitem = new BMenuItem("CR-LF", new BMessage(K_CRLF));
	popup->AddItem(menuitem);
	menuitem->SetTarget(this);
	if(fRetCode == K_CRLF)
		menuitem->SetMarked(true);
	
	BPoint	point(this->Bounds().LeftTop());
	this->ConvertToScreen(&point);
	menuitem = NULL;
	menuitem = popup->Go(point);
	
	if(menuitem != NULL){
		BLooper*	looper;
		BHandler*	target = menuitem->Target(&looper);
		looper->PostMessage(menuitem->Message(), target);
	}
	
	delete popup;
}


void
KRetCodeView::MessageReceived(BMessage* msg)
{
	switch(msg->what){
		case K_LF:
		case K_CR:
		case K_CRLF:
			fRetCode = msg->what;
			this->RedrawText();
			break;
			
		default:
			this->BStringView::MessageReceived(msg);
	}
}


void
KRetCodeView::ConvertFromLF(char** text)
{
	KTextUtils	utils;
	
	if(fRetCode == K_CR || fRetCode == K_CRLF){
		utils.ConvertReturnCode(text, fRetCode);
		
	}else if(fRetCode == K_LF){
		//Do nothing.
	}else{
		
	}
}


void
KRetCodeView::ConvertToLF(char** text)
{
	KTextUtils	utils;
	fRetCode = utils.DetectReturnCode(*text);
	
	if(fRetCode == K_CR || fRetCode == K_CRLF){
		utils.ConvertReturnsToLF(*text);
		
	}else if(fRetCode == K_LF){
		//Do nothing.
	}
	
	this->RedrawText();
}


void
KRetCodeView::RedrawText()
{	
	if(fRetCode == K_CR){
		this->SetText("CR");
		
	}else if(fRetCode == K_CRLF){
		this->SetText("CR-LF");
		
	}else if(fRetCode == K_LF){
		this->SetText("LF");
		
	}
}








