#include "KTViewUtils.h"

#include <TextView.h>
#include <Window.h>

#include "KTextUtils.h"

KTViewUtils::KTViewUtils(BTextView* textview, bool smooth)
	:fTextView(textview), fSmoothScroll(smooth)
{
	
}


KTViewUtils::~KTViewUtils()
{
	
}


void
KTViewUtils::ShowTop()
{
	fTextView->Select(0, 0);
	fTextView->ScrollToSelection();
}

void
KTViewUtils::ShowBottom()
{
	const int32	len = fTextView->TextLength();
	fTextView->Select(len, len);
	fTextView->ScrollToSelection();
}

void
KTViewUtils::ShowLineTop()
{
	int32	startOffset, endOffset;
	
	const char*	text = fTextView->Text();
	fTextView->GetSelection(&startOffset, &endOffset);
	for(int32 i = startOffset - 1; i >= 0; i--){
		if(*(text + i) == B_RETURN){
			fTextView->Select(i + 1, i + 1);
			fTextView->ScrollToSelection();
			break;
		}else if(i == 0){
			this->ShowTop();
		}
	}
}

void
KTViewUtils::SelectToLineTop()
{
	int32	startOffset, endOffset;
	
	const char*	text = fTextView->Text();
	fTextView->GetSelection(&startOffset, &endOffset);
	for(int32 i = startOffset - 1; i >= 0; i--){
		if(*(text + i) == B_RETURN){
			fTextView->Select(i + 1, endOffset);
			fTextView->ScrollToSelection();
			break;
		}else if(i == 0){
			fTextView->Select(0, endOffset);
		}
	}
}

void
KTViewUtils::ShowLineBottom()
{
	int32	startOffset, endOffset;
	int32	len = fTextView->TextLength();
	
	const char*	text = fTextView->Text();
	fTextView->GetSelection(&startOffset, &endOffset);
	for(int32 i = endOffset; i <= len; i++){
		if(*(text + i) == B_RETURN){
			fTextView->Select(i, i);
			fTextView->ScrollToSelection();
			break;
		}else if(i == len){
			this->ShowBottom();
		}
	}
}

void
KTViewUtils::SelectToLineBottom()
{
	int32	startOffset, endOffset;
	int32	len = fTextView->TextLength();
	
	const char*	text = fTextView->Text();
	fTextView->GetSelection(&startOffset, &endOffset);
	for(int32 i = endOffset; i <= len; i++){
		if(*(text + i) == B_RETURN){
			fTextView->Select(startOffset, i);
			fTextView->ScrollToSelection();
			break;
		}else if(i == len){
			fTextView->Select(startOffset, len);
		}
	}
}

void
KTViewUtils::MoveToUpperLine()
{
	int32	startOffset, endOffset;
	
	fTextView->GetSelection(&startOffset, &endOffset);
	BPoint offsetPoint = fTextView->PointAt(startOffset);
	offsetPoint.y -= fTextView->LineHeight();
	startOffset = fTextView->OffsetAt(offsetPoint);
	if(startOffset){
		fTextView->Select(startOffset, startOffset);
		fTextView->ScrollToSelection();
	}else{
		fTextView->Select(0, 0);
		fTextView->ScrollToSelection();
	}
}

void
KTViewUtils::MoveToLowerLine()
{
	int32	startOffset, endOffset;
	
	fTextView->GetSelection(&startOffset, &endOffset);
	BPoint offsetPoint = fTextView->PointAt(startOffset);
	offsetPoint.y += fTextView->LineHeight();
	startOffset = fTextView->OffsetAt(offsetPoint);
	if(startOffset){
		fTextView->Select(startOffset, startOffset);
		fTextView->ScrollToSelection();
	}else{
		fTextView->Select(fTextView->TextLength(), fTextView->TextLength());
		fTextView->ScrollToSelection();
	}
}

void
KTViewUtils::MoveToRight()
{
	int32		start, end;
	KTextUtils	utils;
	
	fTextView->GetSelection(&start, &end);
	const char*	text = fTextView->Text();
	
	int32	codeLen = utils.GetCodeLength(text + end);
	fTextView->Select(end + codeLen, end + codeLen);
}

void
KTViewUtils::MoveToLeft()
{
	int32		start, end;
	KTextUtils	utils;
	
	fTextView->GetSelection(&start, &end);
	const char*	text = fTextView->Text();
	
	for(int32 i = start - 1; i >= 0; i--){
		if(utils.IsTopOfChar(text + i)){
			fTextView->Select(i, i);
			break;
		}
	}
}


void
KTViewUtils::DeleteNextCharacter()
{
	int32	start, end;
	KTextUtils	utils;
	
	fTextView->GetSelection(&start, &end);
	const char*	text = fTextView->Text();
	
	fTextView->Delete(end, end + utils.GetCodeLength(text + end));
}

void
KTViewUtils::DeleteLine()
{	
	int32	startOffset, endOffset, i;
	int32	len = fTextView->TextLength();
	
	const char*	text = fTextView->Text();
	fTextView->GetSelection(&startOffset, &endOffset);
	for(i = startOffset - 1; i >= 0; i--){
		if(*(text + i) == B_RETURN){
			startOffset = i + 1;
			break;
		}else if(i == 0){
			startOffset = 0;
		}
	}
	for(i = endOffset; i <= len; i++){
		if(*(text + i) == B_RETURN){
			endOffset = i;
			break;
		}else if(i == len){
			endOffset = len;
		}
	}
	fTextView->Select(startOffset, startOffset);
	fTextView->Delete(startOffset, endOffset);
}

void
KTViewUtils::DeleteWord()
{
	int32	from, to;
	int32	outFrom, outTo;
	fTextView->GetSelection(&from, &to);
	fTextView->FindWord(from, &outFrom, &outTo);
	fTextView->Delete(outFrom, outTo);
}

void
KTViewUtils::DeletePrevCharacter()
{
	int32	startOffset, endOffset;
	fTextView->GetSelection(&startOffset, &endOffset);
	const char*	text = fTextView->Text();
	if(startOffset == endOffset){
		for(int32 i = startOffset - 1; i > 0; i--){
			if((*(text + i) & 0xc0) != 0x80){
				fTextView->Select(i, i);
				fTextView->Delete(i, endOffset);
				break;
			}
		}
	}else{
		fTextView->Delete();
	}
}

void
KTViewUtils::SelectNextCharacter()
{
	int32	startOffset, endOffset;
	KTextUtils	utils;
	
	fTextView->GetSelection(&startOffset, &endOffset);
	const char*	text = fTextView->Text();
	endOffset += utils.GetCodeLength(text + endOffset);
	fTextView->Select(startOffset, endOffset);
}

void
KTViewUtils::SelectPrevCharacter()
{
	int32	startOffset, endOffset;
	fTextView->GetSelection(&startOffset, &endOffset);
	const char*	text = fTextView->Text();
	for(int32 i = startOffset - 1; i >= 0; i--){
		if((*(text + i) & 0xc0) != 0x80){
			fTextView->Select(i, endOffset);
			break;
		}
	}
	
}

void
KTViewUtils::SelectCurrentWord()
{
	int32	startOffset, endOffset;
	int32	start, end;
	fTextView->GetSelection(&startOffset, &endOffset);
	fTextView->FindWord(startOffset, &start, &end);
	fTextView->Select(start, end);
}

void
KTViewUtils::SelectionToUpperCase()
{
	int32	startOffset, endOffset;
	fTextView->GetSelection(&startOffset, &endOffset);
	int32	len = endOffset - startOffset;
	KTextUtils	utils;
	char*	text = new char[len + 1];
	fTextView->GetText(startOffset, len, text);
	utils.ToUpperCase(text);
	fTextView->Delete();
	fTextView->Insert(startOffset, text, len);
	fTextView->Select(startOffset, endOffset);
	delete []text;
}

void
KTViewUtils::SelectionToLowerCase()
{
	int32	startOffset, endOffset;
	fTextView->GetSelection(&startOffset, &endOffset);
	int32	len = endOffset - startOffset;
	KTextUtils	utils;
	char*	text = new char[len + 1];
	fTextView->GetText(startOffset, len, text);
	utils.ToLowerCase(text);
	fTextView->Delete();
	fTextView->Insert(startOffset, text, len);
	fTextView->Select(startOffset, endOffset);
	delete []text;
}


void
KTViewUtils::PageUp()
{
	const BRect	bounds = fTextView->Bounds();
	const float	height = bounds.Height();
	
	BFont	font;
	uint32	outmode;
	fTextView->GetFontAndColor(&font, &outmode);
	
	fTextView->ScrollBy(0, -height + 2 * font.Size());
}


void
KTViewUtils::PageDown()
{
	const BRect	aBounds = fTextView->Bounds();
	const BRect	aTextRect = fTextView->TextRect();
	const float	aHeight = aBounds.Height();
	
	if(aBounds.bottom == aTextRect.bottom){ return; }
	
	BFont	aFont;
	uint32	aOutMode;
	fTextView->GetFontAndColor(&aFont, &aOutMode);
	
	if(fSmoothScroll){
		thread_id	aThread = spawn_thread(do_scroll_down, "scroll_down", B_LOW_PRIORITY, (void*)fTextView);
		resume_thread(aThread);
		
	}else{
		fTextView->ScrollBy(0, aHeight - 2 * aFont.Size());
	}
	
	
}


status_t
KTViewUtils::do_scroll_up(void* arg)
{
	//BTextView*	aTextView = (BTextView*)arg;
	return	B_NO_ERROR;
}


status_t
KTViewUtils::do_scroll_down(void* arg)
{
	//now testing...
	BTextView*	aTextView = (BTextView*)arg;
	BWindow*	aWindow = aTextView->Window();
	
	aWindow->Lock();
	
	const BRect	aBounds = aTextView->Bounds();
	//const BRect	aTextRect = aTextView->TextRect();
	const float	aHeight = aBounds.Height();
	BFont		aFont;
	uint32		aOutMode;
	aTextView->GetFontAndColor(&aFont, &aOutMode);
	float		aFontSize = aFont.Size();
	
	aWindow->Unlock();
	
	const float	kStep = 30.0;
	const float	kLength = aHeight - 2 * aFontSize;
	BRect		aPrevBounds = aBounds;
	for(int32 i = 0; i < kLength / kStep; i++){
		aWindow->Lock();
		aTextView->ScrollBy(0, kStep);
		if(aPrevBounds == aTextView->Bounds()){ break; }
		else{aPrevBounds = aTextView->Bounds(); }
		aWindow->Unlock();
		::snooze(4000);
	}
	return B_NO_ERROR;
}
























