#ifndef __KTextUtils_h__
#define __KTextUtils_h__

#include <UTF8.h>

enum{
	K_CR = 1,
	K_LF,
	K_CRLF
};

enum {
	NOTSET = 0,
	INPUT,
	OUTPUT,
	REPAIR
};

enum {
	NEW = 1,
	OLD,
	NEC,
	EUC,
	SJIS,
	EUCORSJIS,
	UTF8,
	ASCII
};

enum {
	NUL = 0,
	LF = 10,
	CR = 13,
	ESC = 27,
	SS2 = 142
};

class KTextUtils
{
	public:
		KTextUtils(void);
		
		bool	IsTopOfChar(const char* text){return ((*text & 0xc0) != 0x80);}
		bool	IsASCII(const char* text){return ((*text & 0x80) == 0);}
		bool	IsWordChar(const char* text);
		
		void	ToLowerCase(char* text, bool only1byte = false);
		void	ToLowerCase(char* text, int32 len);
		void	ToUpperCase(char* text, bool only1byte = false);
		void	ToUpperCase(char* text, int32 len);
		
		int32	CountChars(const char* text);
		int32	CountChars(const char* text, int32 len);
		
		int32	GetCodeLength(const char* text);
		
		//Return Code
		void	ConvertReturnsToLF(char* text);
		int32	DetectReturnCode(const char* text);
		void	ConvertReturnCode(char** text, int32 retcode);
		
		//Character Code
		int32	DetectCodeType(const char* text);
		
		void	ConvertCharCodeToUTF8(char** text);
		
		void	JIS2EUC(char** text);
		void	EUC2JIS(char** text);
		
		void	SJIS2UTF8(char** text);
		void	UTF82SJIS(char** text);
		
		void	EUC2UTF8(char** text);
		void	UTF82EUC(char** text);
		
		/* MIME encoding and decoding */
		void	JIS2MIME(char** text);
		void	MIME2JIS(char** text);
		
		bool	SkipESCSeq(const char* text, uint8 temp, bool *in2byte);
		
		//path tool
		char*	GetRelPath(const char* source, const char* dest);
		
		//"C" string tools
		void	Decode_C_String(char* text);
		
		//tools
		void	PrintCharCode(char* text);
		char*	DecodeTypeCode(uint32 code);
		
	private:
		
	
};

#endif


















