#ifndef __KWindow_h__
#define __KWindow_h__

#include <Window.h>
#include <Entry.h>
#include <Messenger.h>

const char		kDefaultWindowName[]	= "Untitled";

const float		kMinimumWidowHight	= 350.0;
const float		kMinimumWindowWidth	= 200.0;

enum{
	M_SHORT_CUT_KEYS	= 'stct'
};



class KWindow:public BWindow
{
	public:
				KWindow(BRect frame, const char* name, BEntry* entry = NULL);
				~KWindow();
				
		void	MessageReceived(BMessage* msg);
		bool	QuitRequested();
		void	MenusBeginning();
		
		void	SetEntry(BEntry* entry){ delete fEntry; fEntry = entry; }
		BEntry*	GetEntry()const{ return fEntry; }
		
		void	SetDirty(bool dirty){ fDirty = dirty; }
		bool	GetDirty()const{ return fDirty; }
		
		void	SetTrackerToken(BMessenger* msgr){ delete fTrackerViewToken; fTrackerViewToken = msgr; }
		
		void	SetMemorizeWindow(bool status){ fMemorizeWindow = status; }
		bool	DoesMemorizeWindow()const{ return fMemorizeWindow; }
		
		
	private:
		void	SetupShortcut();
		
		void	ShowSavePanel();
		void	Save();
		
		void	Fusion();
		void	Fusion_PreProcess();
		void	Fusion_Text();
		void	Fusion_PostProcess();
		
		void	WriteAttrs();
		void	MakeNewFile(const char* name, const entry_ref* dir);
		void	AddChildren();
		void	RemoveWindowPointer();
		
		void	ShowTextInformation();
		
		void	SendEmail(bool send_now);
		void	ShowHeaders();
		void	SetStatusNEW2READ(BEntry* entry);
		
		void	OpenEntriesBeside(BMessage* msg);

		void	OpenWithBrowser();
		void	OpenWithBeMail();
		void	ExecAddon(BMessage* msg);
		
		BEntry*			fEntry;
		bool			fDirty;
		BFilePanel*		fSavePanel;
		bool			fMemorizeWindow;
		BMessenger*		fTrackerViewToken;
};

#endif


