/*
	BeOS socketpair() replacement, sendmsg() and recvmsg()
    Found all over the net, edited by Zenja Solaja 2001
*/


#include <sys/types.h>
#include <iovec.h>
#include <stdlib.h>
#include <stdio.h> 
#include <sys/types.h> 
#include <sys/socket.h> 
#include <netinet/in.h> 
#include <errno.h>
#include <unistd.h>
#include <netdb.h> 
#include "beospluggins.h"

//#define O_NDELAY O_NONBLOCK

/* 
 * use		inet_socketpair (AF_INET, SOCK_STREAM, 0, xv) 
 * as		socketpair (AF_UNIX, SOCK_STREAM, 0, xv) 	replacement.
 *
 * Kudos to Solaris people for providing a working solution - Zenja. 
 */ 

int inet_socketpair (int d, int type, int protocol, int sv[2]) 
{ 
	struct sockaddr_in addr1, addr2, addr3;
	int addr3_len = sizeof (addr3);
	int fd, rc;
	static int port_no = 2345;	/* XXX: ok ? */
	
	if (d != AF_INET || type != SOCK_STREAM || protocol)
	{
		perror("inet_socketpair - bad param in inet_socketpair.");
		return -1;
	}
	if ((sv [0] = socket (AF_INET, SOCK_STREAM, 0)) < 0
		|| (sv [1] = socket (AF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror ("inet_socketpair - cannot create sockets; reason");
		return -1;
	}
	addr1.sin_port = htons (port_no);
	addr1.sin_family = AF_INET;
	addr1.sin_addr.s_addr = 0;
	
	while ((rc = bind (sv[0], (struct sockaddr *) &addr1, sizeof (addr1))) < 0
		&& errno == EADDRINUSE)
		addr1.sin_port = htons (++port_no);
	if (rc < 0)
	{
		perror ("inet_socketpair - cannot bind; reason");
		return -1;
	}
	
	if (listen (sv[0], 1) < 0)
	{
		perror ("inet_socketpair - cannot listen; reason");
		return -1;
	}
	
	addr2.sin_port = htons (port_no);
	addr2.sin_family = AF_INET;
	addr2.sin_addr.s_addr = htonl (INADDR_LOOPBACK);
	if (connect (sv[1], (struct sockaddr *) &addr2, sizeof (addr2)) < 0)
	{
		perror ("inet_socketpair - cannot connect; reason");
		return -1;
	}
	if ((fd = accept (sv[0], (struct sockaddr *) &addr3, &addr3_len)) < 0)
	{
		perror ("inet_socketpair - cannot accept; reason");
		return -1;
	}
	
	if (close (sv[0]) < 0)
	{
		perror ("inet_socketpair - cannot close; reason");
		return -1;
	}
	
	sv[0] = fd;
	/**    printf ("* returning sv[0]=%d  sv[1]=%d\n", sv[0], sv[1]); **/
	/* okey dokey mom */
	perror("inet_socketpair - success.");
	return 0;
}

//====================
ssize_t recvmsg(int s, struct msghdr *msg, int flags)
{
	if (s<0) {
		perror("recvmsg - invalid socket");
		return -1;
	}
	ssize_t ret, nb;
	size_t tot = 0;
	int i;
	char *buf, *p;
	
	struct iovec *iov = msg->msg_iov;
		
	for(i = 0; i < msg->msg_iovlen; ++i)
		tot += iov[i].iov_len;
	buf = (char *)malloc(tot);
	if (tot != 0 && buf == NULL) {
		perror("recvmsg - not enough buffer memory");
		errno = ENOMEM;
		return -1;
	}
	nb = ret = recvfrom (s, buf, tot, flags, (struct sockaddr *) msg->msg_name, (int *)&msg->msg_namelen);
	if (ret < 0) {
		perror("recvmsg - ret<0");
		return -1;
	}	
	p = buf;
	if (p==NULL)
		perror("recvmsg - Error p=NULL");
	while (nb > 0) {
		ssize_t cnt = (nb < iov->iov_len ? nb : iov->iov_len);
		memcpy (iov->iov_base, p, cnt);
		p += cnt;
		nb -= cnt;
		++iov;
	}
	free(buf);
	perror("recvmsg-Success");
	return ret;
}


//====================
ssize_t sendmsg(int s, const struct msghdr *msg, int flags)
{
    ssize_t ret;
    size_t tot = 0;
    int i;
    char *buf, *p;
    struct iovec *iov = msg->msg_iov;

    for(i = 0; i < msg->msg_iovlen; ++i)
        tot += iov[i].iov_len;
    buf = (char *)malloc(tot);
    if (tot != 0 && buf == NULL) {
        perror("sendmsg-not enough memory");
        errno = ENOMEM;
        return -1;
    }
    p = buf;
    for (i = 0; i < msg->msg_iovlen; ++i) {
        memcpy (p, iov[i].iov_base, iov[i].iov_len);
        p += iov[i].iov_len;
    }
    ret = sendto (s, buf, tot, flags, (sockaddr *) msg->msg_name, msg->msg_namelen);
    free (buf);
    perror("sendmsg-Success");
    return ret;
}