/* Structure describing messages sent by
   `sendmsg' and received by `recvmsg'.  */
#ifndef _C_MSG_H
#define _C_MSG_H

#ifndef __socklen_t_defined
typedef int socklen_t;
#define __socklen_t_defined
#endif

struct msghdr 
{
	void *msg_name;            // Address to send to/receive from.  
	socklen_t msg_namelen;     // Length of address data.  
	struct iovec *msg_iov;     // Vector of data to send/receive into.  
	int msg_iovlen;            // Number of elements in the vector.  
	void *msg_control;         // Ancillary data (eg BSD filedesc passing). 
	
	socklen_t msg_controllen;  // Ancillary data buffer length.  
	int msg_flags;             // Flags in received message.  
};

/* Structure used for storage of ancillary data object information.  */
struct cmsghdr
{
socklen_t cmsg_len;                /* Length of data in cmsg_data plus length
	                                  of cmsghdr structure.  */
int cmsg_level;            /* Originating protocol.  */
int cmsg_type;             /* Protocol specific type.  */
//__extension__ unsigned char __cmsg_data __flexarr; /* Ancillary data.  */
unsigned char __cmsg_data;
};

/* Ancillary data object manipulation macros.  */
#if !defined __STRICT_ANSI__ && defined __GNUC__ && __GNUC__ >= 2
#define CMSG_DATA(cmsg) ((cmsg)->__cmsg_data)
#else
#define CMSG_DATA(cmsg) ((unsigned char *) ((struct cmsghdr *) (cmsg) + 1))
#endif

#define CMSG_NXTHDR(mhdr, cmsg) __cmsg_nxthdr (mhdr, cmsg)
#define CMSG_FIRSTHDR(mhdr) \
		((size_t) (mhdr)->msg_controllen >= sizeof (struct cmsghdr) \
		? (struct cmsghdr *) (mhdr)->msg_control : (struct cmsghdr *) NULL)

#define __CMSG_ALIGN(len) (((len) + sizeof (size_t) - 1) \
		& (size_t) ~(sizeof (size_t) - 1))
#define CMSG_ALIGN(len)        __CMSG_ALIGN (len)
#define CMSG_SPACE(len) (__CMSG_ALIGN (len) \
		+ __CMSG_ALIGN (sizeof (struct cmsghdr)))
#define CMSG_LEN(len)   (__CMSG_ALIGN (sizeof (struct cmsghdr)) + (len))

/* Socket level message types.  */
enum
{
	SCM_RIGHTS = 0x01          /* Access rights.  */
#define SCM_RIGHTS SCM_RIGHTS
};

#endif // _C_MSG_H
	