#ifndef __kio_scheduler_h__
#define __kio_scheduler_h__

#include <qobject.h>
#include <qdict.h>
#include <qtimer.h>
#include <qlist.h>

#define SAM_MAX_TASKS 3

namespace KIO
{
    class SimpleJob;
    class Slave;

    class Scheduler : public QObject
    {
        Q_OBJECT
    public:
        Scheduler();
        virtual ~Scheduler();

        bool doJob( SimpleJob *job );

        void releaseJob( SimpleJob *job, bool killSlave = false );

        // ### check if this is correct
#if (OSTYPE==beos)
		static void scheduleJob(SimpleJob* );
#else        
        static void scheduleJob( SimpleJob * ) {}
#endif

        static Scheduler *self();

    private slots:
        void slotStep();

    private:
        static Slave *createSlave( const QString &prot );

        struct ProtocolInfo
        {
            ProtocolInfo();
	    ~ProtocolInfo();

            QList<SimpleJob> m_jobs;
            bool m_running[SAM_MAX_TASKS];
            Slave *m_slaves[SAM_MAX_TASKS];
	    int m_running_cnt;
        };

        void doStep( ProtocolInfo *nfo );

        void killSlave( ProtocolInfo *nfo, int task = -1 );

        QTimer m_timer;
        QDict<ProtocolInfo> m_schedule;
        static Scheduler *s_self;
    };

};

#endif
