/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "slave.h"

#include <kdebug.h>

using namespace KIO;

Slave::Slave( Connection *conn, pid_t pid )
    : SlaveInterface( conn )
{
    m_pid = pid;
    conn->connect( this, SLOT( slotDispatch() ) );
}

Slave::~Slave()
{
    kdDebug() << "Slave::~Slave()" << endl;
    if ( connection()->inited() ) {
        int infd = connection()->fd_from();
        int outfd = connection()->fd_to();
        connection()->close();
        ::close( infd );
        ::close( outfd );
    }   

    // ###
    delete connection();
}

void Slave::slotDispatch()
{
    kdDebug() << "Slave::slotDispatch()" << endl;
    if ( !dispatch() )
    {
        connection()->close();

        // ### FIXME!
//        emit slaveDied( this ); // this will make the scheduler delete us
    }
}

void Slave::kill()
{
    kdDebug() << "Slave::kill()" << endl;
    if ( m_pid )
        ::kill( m_pid, SIGTERM );
}

void Slave::setConfig( const MetaData &config )
{
    QByteArray data;
    QDataStream stream( data, IO_WriteOnly );
    stream << config;
    send( CMD_CONFIG, data );
}

#include "slave.moc"
