#ifndef __ksocks_h__
#define __ksocks_h__

#include <netsupp.h>

#include <sys/socket.h>
#include <unistd.h>

class KSocks
{
public:
    inline int bind( int sockfd, sockaddr *my_addr, ksocklen_t addrlen )
    { return ::bind( sockfd, my_addr, addrlen ); }

    inline int listen( int s, int backlog )
    { return ::listen( s, backlog ); }

    inline int select( int n, fd_set *readfds, fd_set *writefds, fd_set *exceptfds,
                       struct timeval *timeout)
    { return ::select( n, readfds, writefds, exceptfds, timeout ); }

    inline int accept( int s, sockaddr *addr, ksocklen_t *addrlen )
#if (OSTYPE==beos)
	{ return ::accept( s, addr, (int *) addrlen ); }
#else
	{ return ::accept( s, addr, addrlen ); }
#endif

    inline int connect( int sockfd, const sockaddr *serv_addr, ksocklen_t addrlen )
    { return ::connect( sockfd, serv_addr, addrlen ); }

    inline signed long int read ( int fd, void *buf, unsigned long int count )
    { return ::read( fd, buf, count ); }

    inline long int write( int fd, const void *buf, unsigned long int count )
    { return ::write( fd, buf, count ); }

    inline int getsockname( int s, sockaddr *name, ksocklen_t *namelen )
#if (OSTYPE==beos)
	{ return ::getsockname( s, name, (int *) namelen ); }
#else
    { return ::getsockname( s, name, namelen ); }
#endif

    inline int getpeername( int s, sockaddr *name, ksocklen_t *namelen )
#if (OSTYPE==beos)
	{ return ::getpeername( s, name, (int *) namelen ); }
#else
	{ return ::getpeername( s, name, namelen ); }
#endif

    static KSocks *self()
    {
        if ( !s_self )
            s_self = new KSocks;
        return s_self;
    }

private:
    static KSocks *s_self;
};

#endif
