/* This file is part of the KDE project
 *
 * Copyright (C) 2000 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>

#include "ksslpeerinfo.h"
#include <qstring.h>
#include <kdebug.h>

#include <ksockaddr.h>
#include <kextsock.h>

#include "ksslx509map.h"

class KSSLPeerInfoPrivate {
public:
  KInetSocketAddress *host;
};



KSSLPeerInfo::KSSLPeerInfo() {
  d = new KSSLPeerInfoPrivate;
  d->host = NULL;
}

KSSLPeerInfo::~KSSLPeerInfo() {
  delete d;
}

KSSLCertificate& KSSLPeerInfo::getPeerCertificate() {
  return m_cert;
}

void KSSLPeerInfo::setPeerAddress(KInetSocketAddress& addr) {
  if (!d->host)
    d->host = new KInetSocketAddress(addr);
  else
    (*d->host) = addr;
}


bool KSSLPeerInfo::certMatchesAddress() {
#ifdef HAVE_SSL
  KSSLX509Map certinfo(m_cert.getSubject());
  int err;
  QList<KAddressInfo> cns = KExtendedSocket::lookup(certinfo.getValue("CN").latin1(), 0, 0, &err);
  cns.setAutoDelete(true);

  kdDebug(7029) << "The original ones were: " << d->host->nodeName()
            << " and: " << certinfo.getValue("CN").latin1()
            << endl;

  for (KAddressInfo *x = cns.first(); x; x = cns.next()) {
     // kdDebug(7029) << "Found address: " << (**x).pretty() << endl;
     if ((*x).address()->isCoreEqual(d->host))
        return true;
  }

#endif
  return false;
}
