#ifndef __dcopdispatcher_h__
#define __dcopdispatcher_h__

#include <qcstring.h>
#include <qlist.h>
#include <qobject.h>
#include <qvaluelist.h>
#include <qasciidict.h>

#include <dcopobject.h>

class QSocketNotifier;

namespace KIO
{
    class Connection;
};

class DCOPClientTransaction;

class DCOPDispatcher : public QObject
{
    Q_OBJECT
public:
    DCOPDispatcher();
    virtual ~DCOPDispatcher();

    DCOPClientTransaction *beginTransaction();
    void endTransaction( DCOPClientTransaction *transaction, QCString &replyType, QByteArray &replyData );

    // extension
    void addClient( KIO::Connection *connection, QObject *owner );

    bool process( const QCString &appname,
		  const QCString &fun, const QByteArray &data,
		  QCString &replyType, QByteArray &replyData );

    void registerObject(DCOPObject *obj)
        {
            m_objpool.insert( obj->objId(), obj );
        }

    void unregisterObject(DCOPObject *obj)
        {
            m_objpool.remove( obj->objId() );
        }

    static DCOPDispatcher *self();

private slots:
    void slotDisconnectClient();
    void slotDispatch( int sockfd );

private:
    struct Client
    {
        KIO::Connection *m_connection;
        QObject *m_owner;
        QSocketNotifier *m_notifier;
        int m_infd;
    };
    QList<Client> m_clients;

    void disconnectClient( const QObject *owner );
    void dispatchClient( Client *client );

    struct InternalDCOPClientTransaction
    {
        Client *m_client;
    };

    QList<InternalDCOPClientTransaction> m_transactions;

    bool m_transactionAdded;

    QAsciiDict<DCOPObject> m_objpool;

    static DCOPDispatcher *s_self;

    static Client *s_currentClient;
};

#endif
