/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "kio_file.h"

#include <qdir.h>
#include <qfileinfo.h>
#include <qtextstream.h>

using namespace KIO;

#define MAX_IPC_SIZE (1024*32)

File::File()
    : SlaveBase( "file" )
{
}

File::~File()
{
}

void File::get( const KURL &url )
{
    QString path = url.path();

    QFileInfo info( path );

    if ( !info.exists() )
    {
        error( KIO::ERR_DOES_NOT_EXIST, path );
        return;
    }

    if ( info.isFile() )
    {
        QFile file( path );
	unsigned long bytes_read = 0;

        if ( !file.open( IO_ReadOnly ) )
        {
            error( KIO::ERR_CANNOT_OPEN_FOR_READING, path );
            return;
        }

        totalSize( info.size() );

        while ( !file.atEnd() )
        {
            QByteArray buffer( MAX_IPC_SIZE );

            int n = file.readBlock( buffer.data(), buffer.size() );
            buffer.truncate( n );

            if ( n == -1 )
            {
                error( KIO::ERR_COULD_NOT_READ, path );
                return;
            }

	     bytes_read += n;

	    processedSize( bytes_read );

            data( buffer );
        }

        data( QByteArray() ); // ### why is that needed?


    }
    else if ( info.isDir() )
    {
        QDir dir( info.absFilePath() );

        const QFileInfoList *entries = dir.entryInfoList();
	
	if( entries )
	{
  	    totalSize( entries->count() );

	    // the header
	    QByteArray header_buffer;
	    QTextStream header_stream( header_buffer, IO_WriteOnly );
	    header_stream << QString::fromLatin1( "<html><body><pre>" );
	    data( header_buffer );

    	    QFileInfoListIterator it( *entries );
	    
	    for ( unsigned long c = 0; it.current(); ++it, c++ )
	    {
	         QByteArray buffer;

		 QTextStream stream( buffer, IO_WriteOnly );

	         stream << QString::fromLatin1( "<a href=\"%1\">%2</a>\n" )
		      .arg( it.current()->absFilePath().
			    prepend( QString::fromLatin1( "file:" ) ) )
		      .arg( it.current()->fileName() );

		 processedSize( c + 1 );

		 data( buffer );

	    }

	    // the footer
	    QByteArray footer_buffer;
	    QTextStream footer_stream( header_buffer, IO_WriteOnly );
	    footer_stream << QString::fromLatin1( "</pre></body></html>" );
	    data( footer_buffer );

	    data( QByteArray() );

        }
	
    }

    finished();
}
