/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "krun.h"

#include "jobclasses.h"
#include "job.h"
#include "kprotocolmanager.h"
#include <kparts/browserextension.h>

#include <qimage.h>
#include <qbuffer.h>

#include <assert.h>
#include <unistd.h>
#include <stdlib.h>

#if defined(_QT_QPE_)
// ### HACK to resolve kio:global.h <> qpe:global.h conflict!
#include <../library/global.h>
#endif

// ###
#include <khtml_run.h>

KRun::KRun( const KURL &url, int, bool, bool )
{
    m_strURL = url;
    QTimer::singleShot( 0, this, SLOT( slotStart() ) );
    m_job = 0;
}

void KRun::foundMimeType( const QString & )
{
}

void KRun::slotStart()
{
//    if ( !inherits( "KHTMLRun" ) )
//        foundMimeType( "text/html" );

    QString externalHandler = KProtocolManager::externalProtocolHandler( m_strURL.protocol() );
    if ( !externalHandler.isEmpty() )
    {
        exec( externalHandler, m_strURL.url() );

        emit error(); // stop the spinning wheel, err, the enabled stop button

        delete this; // pretend you don't see this :)
        return;
    } 

    // eeeeek!
    KHTMLRun *run = static_cast<KHTMLRun *>( this );

    KIO::TransferJob *job = 0;

    if ( run->urlArgs().postData.size() > 0 )
    {
        job = KIO::http_post( m_strURL, run->urlArgs().postData, false );
        job->addMetaData( "content-type", run->urlArgs().contentType() );
    }
    else
        job = KIO::get( m_strURL, false, false );

    job->addMetaData( run->urlArgs().metaData() );

    // ###
    connect( job, SIGNAL( data( KIO::Job *, const QByteArray & ) ),
             this, SLOT( slotJobData( KIO::Job *, const QByteArray & ) ) );
    connect( job, SIGNAL( result( KIO::Job * ) ),
             this, SLOT( slotJobResult( KIO::Job * ) ) );

    m_job = job;
}

void KRun::slotJobData( KIO::Job *job, const QByteArray &data )
{
    assert( job->inherits( "KIO::TransferJob" ) );
    assert( job == m_job );

    KIO::TransferJob *transferJob = static_cast<KIO::TransferJob *>( job );

    KURL url = transferJob->url();

    QString mtype = QString::fromLatin1( "text/html" );

    QBuffer buffer( data );
    buffer.open( IO_ReadOnly );
    if ( QImageIO::imageFormat( &buffer ) != 0 )
       mtype = QString::fromLatin1( "image/*" ); // ###

    transferJob->detach( data );

    job->disconnect( this, 0 );

    foundMimeType( mtype );

    // check this again
    // this is extremely evil and relies on only one slot
    // connected to the signal. uhoh :)
    delete this;
}

void KRun::slotJobResult( KIO::Job *job )
{
    if ( job->error() )
    {
        job->showErrorDialog( 0 ); // ### parent
        emit error();
    }

    // this is extremely evil and relies on only one slot
    // connected to the signal. uhoh :)
    delete this;
}

void KRun::exec( const QString &app, const QString &arg )
{
#if defined(_QT_QPE_)
    Global::execute( app, arg ); 
#else
    QCString cmdline = app.local8Bit() + " " + arg.local8Bit();

    int pid = fork();
    if ( pid == -1 )
       return;

    // parent
    if ( pid != 0 )
        return;

    int i = getdtablesize();
    while ( i >= 3 )
    {
        ::close( i );
        i--;
    }

    const char *shell = "/bin/sh";
    execl( shell, shell, "-c", cmdline.data() );
    ::exit( 1 );
#endif
}

#include "krun.moc"
