#ifndef EXTERN_MD5_H
#define EXTERN_MD5_H "$Id: extern_md5.h,v 1.7 2000/09/09 22:06:45 matz Exp $"

//typedef unsigned INT32_BASETYPE UINT32_T;
typedef unsigned int UINT32_T;	//OS_BEOS 

#ifdef DO_MD5

#define HASHLEN 16
typedef char HASH[HASHLEN];
#define HASHHEXLEN 32
typedef char HASHHEX[HASHHEXLEN+1];

/* MD5 context. */
typedef struct Local_MD5Context {
  UINT32_T state[4];   /* state (ABCD) */
  UINT32_T count[2];   /* number of bits, modulo 2^64 (lsb first) */
  unsigned char buffer[64];     /* input buffer */
} Local_MD5_CTX;

#ifdef __cplusplus
extern "C" {
#endif
	/* calculate H(A1) as per HTTP Digest spec */
	extern void DigestCalcHA1 (const unsigned char *pszAlg, const unsigned char *pszUserName, const unsigned char *pszRealm, const unsigned char *pszPassword, const unsigned char *pszNonce, const unsigned char *pszCNonce, HASHHEX SessionKey);

	/* calculate request-digest/response-digest as per HTTP Digest spec */
	extern void DigestCalcResponse (HASHHEX HA1, const unsigned char *pszNonce, const unsigned char *pszNonceCount, const unsigned char *pszCNonce, const unsigned char *pszQop, const unsigned char *pszMethod, const unsigned char *pszDigestUri,  HASHHEX HEntity, HASHHEX Response);

	void MD5Init (Local_MD5_CTX *);
	void MD5Update (Local_MD5_CTX *, const unsigned char *, unsigned int);
	void MD5Pad (Local_MD5_CTX *);
	void MD5Final (unsigned char [16], Local_MD5_CTX *);
	char *MD5End(Local_MD5_CTX *, char *);
	char *MD5File(const char *, char *);
	char *MD5Data(const unsigned char *, unsigned int, char *);
	static void MD5Transform (UINT32_T state[4], const unsigned char block[64]);
#ifdef __cplusplus
}
#endif

#endif
#endif
