/*  This file is part of the KDE project
    Copyright (C) 2000,2001 Simon Hausmann <hausmann@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#define protected public
#include <qstyle.h>
#undef protected

#include <config.h>
#include <kapp.h>
#include <kcookieserver.h>
#include <authcache.h>
#include <khtml_part.h>
#include <klibloader.h>
#include <ecma/kjs_proxy.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <qtranslator.h>

#ifdef _WS_QWS_
#include <qwsdisplay_qws.h>
#endif

#include <signal.h>

#include "popuphandler.h"
#include "mainwindow.h"
#include "pics/file_broken.xpm"

// ### from ecma/kjs_proxy.cpp and khtml_factory.cpp
extern "C"
{
#ifdef ENABLE_JAVASCRIPT
    KJSProxy *kjs_html_init( KHTMLPart * );
#endif
    void *init_libkhtml();
}

// ### from http_cache_cleaner.cpp
extern int http_cache_cleaner_main( int, char ** );

// ### from khtml_part.cpp
extern int kjs_lib_count;

#ifdef NDEBUG
void messageHandler( QtMsgType , const char *)
{
	// eat this
}
#endif

int main( int argc, char **argv )
{
    signal( SIGCHLD, SIG_IGN );

    kjs_lib_count++; // ### hack, prevent khtmlpart from deleting the js klibrary object

#ifdef NDEBUG
    qInstallMsgHandler( messageHandler );
#endif

    KApplication app( argc, argv, "konq-embed" );

#ifndef QT_NO_TRANSLATION

    char *lang = getenv( "LANG" );
    if ( lang )
    {
        QString qmFile = QString::fromLatin1( "konqueror_%1.qm" ).arg( QString::fromLatin1( lang ) );

        // locate the message file in $prefix/share/locale/
        qmFile = locate( "locale", qmFile );

        QTranslator *translator = new QTranslator( &app );
        if ( translator->load( qmFile ) )
            app.installTranslator( translator );
        else
            delete translator;
    }

#endif

    (void)new PopupHandler( &app, "popup-handler" );

#ifdef _WS_QWS_
#ifndef QT_NO_QCOP
#if QT_VERSION == 224
#warning workaround for qt2.2.4 bug
    (void)new QCopChannel( "qt224bugdummychanneltopreventcrashinqapplication_qwsdotcpp" );
#endif
#endif
#endif

    KAuthCacheServer authCache;
    KCookieServer cookieEater;

    authCache.setObjId( "authcache" );
    cookieEater.setObjId( "kcookiejar" );

#ifdef ENABLE_JAVASCRIPT
    KLibLoader::self()->library( "kjs_html" )->registerSymbol( "kjs_html_init", (void *)&kjs_html_init );
#endif
//    KLibLoader::self()->library( "libkhtml" )->registerSymbol( "init_libkhtml", (void *)&init_libkhtml );

    KApplication::setService( "http_cache_cleaner.desktop", (void *)&http_cache_cleaner_main );

    KIconLoader::self()->registerIcon( "file_broken", QPixmap( file_broken_xpm ) );

    QObject::connect( &app, SIGNAL( lastWindowClosed() ), &app, SLOT( quit() ) );

    MainWindow *toplevel = MainWindow::instantiate();

    toplevel->show();

    bool openedMainWindow = false;

#if defined(_QT_QPE_)
    app.setMainDocumentWidget( toplevel );

    openedMainWindow = ( argc == 2 ) && ( toplevel->currentView() != 0 );
#else
    app.setMainWidget( toplevel );

    for ( int i = 1; i < argc; i++ )
    {
       KURL u = QString::fromLatin1( QCString( argv[ i ] ) );
       if ( !u.isMalformed() && !u.isEmpty() )
       {
           toplevel->createNewView( u );
           openedMainWindow = true;
       }
    }
#endif

    if ( !openedMainWindow )
    {
        QString startDocumentPath = locate( "data", "konq-embed/start.html" );
        if ( !startDocumentPath.isEmpty() )
            toplevel->createNewView( startDocumentPath.prepend( "file:" ) );
        else
            toplevel->createNewView( KURL() );
    }

    return app.exec();
}
