/*
	LMAdvance.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMAdvance.h"

#define ESC_LEN 3
const static byte escape[ESC_LEN] = {0x1b, 0x2a, 0x03};

LMAdvance::LMAdvance()
{
	offset = 0;
}

LMAdvance::LMAdvance(int16 offset)
{
	this->offset = offset;
}

LMAdvance::~LMAdvance()
{
}

void
LMAdvance::SetOffset(int16 offset)
{
	this->offset = offset;
}

status_t
LMAdvance::Write(BDataIO * file)
{
	int16 o;
	int32 result;
	
	o = htons(offset);
	
	result = file->Write(escape, ESC_LEN);
	if (!result)
		return B_ERROR;
	
	result = file->Write(&o, 2);
	if (!result)
		return B_ERROR;
		
	return B_OK;
}

