/*
	LMDriver.h
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#ifndef _LM_DRIVER_H
#define _LM_DRIVER_H

#include "LMDefs.h"

extern "C" {
	typedef BDataIO *(*PFN_init_transport)(BMessage *);
	typedef void (*PFN_exit_transport)(void);
}

class LMDriver
{
public:
 
	LMDriver();
	~LMDriver();
	
	status_t Print(BFile * spool, BNode * printer, BMessage * msg);

private:
	void PrintPage(BFile * spool, BMessage * msg);
	void PrintPageL(BFile * spool, BMessage * msg);
	status_t GetTransport(BNode * printer);
	void CloseTransport();
	
	BBitmap * bitmap;
	BView * view;
	PFN_init_transport init_transport;
	PFN_exit_transport exit_transport;
	BDataIO * transport;
	image_id transport_add_on;
};

#endif

	