/*
	LMJobSetup.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMJobSetup.h"

LMJobSetup::LMJobSetup(BMessage * msg)
 : BWindow(BRect(0,0,JOB_SETUP_WIDTH, JOB_SETUP_HEIGHT), "Job Setup", B_TITLED_WINDOW_LOOK,
 			B_MODAL_APP_WINDOW_FEEL, B_NOT_RESIZABLE | B_NOT_MINIMIZABLE |
 			B_NOT_ZOOMABLE)
{
	print_msg = msg;
	sem = create_sem(0, "LMJobSetup");
	view = new LMJobSetupView(msg);
	Lock();
	AddChild(view);
	Unlock();
}

LMJobSetup::~LMJobSetup()
{
}

void
LMJobSetup::MessageReceived(BMessage * msg)
{
	switch (msg->what)
	{
		case M_OK:
			((LMJobSetupView *)ChildAt(0))->UpdateJobData(print_msg);
			result = B_OK;
			release_sem(sem);
			break;
		
		case M_CANCEL:
			result = B_ERROR;
			release_sem(sem);
			break;
		
		case M_ALL:
			view->EnableRange(false);
			break;
			
		case M_RANGE:
			view->EnableRange(true);
			break;
			
		default:
			BWindow::MessageReceived(msg);
			break;
	}
}
			
bool LMJobSetup::QuitRequested()
{
	result = B_ERROR;
	release_sem(sem);
	return true;
}

status_t
LMJobSetup::Go()
{
	MoveTo(300,300);
	Show();
	acquire_sem(sem);
	delete_sem(sem);
	Lock();
	Quit();
	return result;
}
