/*
	LMJobSetupView.h
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#ifndef LM_JOBSETUP_VIEW_H
#define LM_JOBSETUP_VIEW_H

#include <InterfaceKit.h>
#include "LMDefs.h"

#define JOB_SETUP_HEIGHT 150
#define JOB_SETUP_WIDTH 300

#define M_OK 1
#define M_CANCEL 2
#define M_ALL 3
#define M_RANGE 4

class LMJobSetupView : public BView
{
public:

	LMJobSetupView(BMessage * msg);
	~LMJobSetupView();

	virtual void AttachedToWindow();
	void UpdateJobData(BMessage * msg);
	void EnableRange(bool enabled);
	
private:
	BButton * ok;
	BButton * cancel;
	BBox * pagebox;
	BBox * copybox;
	BRadioButton * all;
	BRadioButton * range;
	BTextControl * start;
	BTextControl * end;
	BTextControl * copies;
	
	BMessage * msg;
};



#endif
