/*
	LMPageLoad.cpp
	12 October 2000
	This code is part of Ryan Lockhart's Lexmark 5xxx and 7xxx driver for BeOS.
	It is distributed with no warranty of any kind, in hope that it may be useful
	to someone.
*/

#include "LMPageLoad.h"

#define _LX7_INIT4 0x1b,0x2a,0x07,0x73,0x30 
#define _LX7_INIT5 0x1b,0x2a,0x07,0x63
#define _LX7_INIT6 0x1b,0x2a,0x6d,0x00,0x42,0x00,0x00

static byte load_bytes[LOAD_LEN] = {_LX7_INIT4, _LX7_INIT4, _LX7_INIT5, _LX7_INIT6};

LMPageLoad::LMPageLoad()
{
}


LMPageLoad::~LMPageLoad()
{
}

status_t
LMPageLoad::Write(BDataIO * file)
{
	if (file->Write(load_bytes, LOAD_LEN) > 0)
		return B_OK;
	else
		return B_ERROR;
}